package org.mule.devkit.maven;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

import java.util.*;

/**
 * Used for validation purposes only, this mojo will guarantee that the current compilation will have the necessary
 * javadocs for every field, parameter, method, etc., that devkit needs to generate the documentation
 */
@Mojo(name = "ensure-javadoc", requiresDependencyResolution = ResolutionScope.COMPILE)
public class EnsureJavaDocMojo extends AnnotationProcessorMojo {

    private static String[] processors = {"org.mule.devkit.apt.EnsureJavaDocAnnotationProcessor"};

    /**
     * As we are validating in this "ensure-javadoc" goal, we want to validate *always* that the connector is properly
     * documented
     *
     * @param options
     */
    @Override
    protected void addCompilerJavadocArgument(List<String> options) {
        options.add("-AenableJavaDocValidation=true");
    }

    /**
     * As we are validating in this "ensure-javadoc" goal, it does not have sense to generate the Studio plugin
     *
     * @param options
     */
    @Override
    protected void addCompilerStudioPluginArgument(List<String> options) {
        options.add("-AenabledStudioPluginPackage=false");
    }
}
