/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.maven;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;

import java.io.File;

/**
 * Base Mule Application Mojo
 */
public abstract class AbstractMuleMojo extends AbstractMojo {
    /**
     * Directory containing the generated Mule App.
     */
    @Parameter(required = true, defaultValue = "${project.build.directory}")
    protected File outputDirectory;

    /**
     * Name of the generated Mule App.
     */
    @Parameter(required = true, alias = "appName", defaultValue = "${project.build.finalName}")
    protected String finalName;

    /**
     * Directory containing the app resources.
     */
    @Parameter(required = true, defaultValue = "${basedir}/src/main/app")
    protected File appDirectory;

    /**
     * The Maven project.
     */
    @Parameter(required = true, defaultValue = "${project}", readonly = true)
    public MavenProject project;



    /**
     * Whether to skip the creating of a Mule Studio plugin.
     */
    @Parameter(property = "devkit.studio.package.skip", defaultValue = "true")
    protected boolean skipStudioPluginPackage;

    protected File getMuleZipFile() {
        return new File(this.outputDirectory, this.finalName + ".zip");
    }

    protected File getFilteredAppDirectory() {
        return new File(outputDirectory, "app");
    }
}
