/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.devkit.apt.MavenLicense;
import org.mule.devkit.generation.utils.SerializationUtils;
import org.mule.devkit.maven.AbstractAnnotationProcessorMojo;
import org.mule.devkit.maven.MavenLicenseBuilder;

@MojoGoal(value="generate-sources")
@MojoRequiresDependencyResolution(value="compile")
@MojoPhase(value="generate-sources")
public class AnnotationProcessorMojo
extends AbstractAnnotationProcessorMojo {
    private static String[] processors = new String[]{"org.mule.devkit.apt.AnnotationProcessor"};
    public static final String LICENSE_DESCRIPTOR_FILE_NAME = "license.descriptor";
    @MojoParameter(expression="${project.compileClasspathElements}", required=true, readonly=true)
    private List classpathElements;
    @MojoParameter(expression="${project.build.directory}/generated-sources/mule", required=true)
    private File defaultOutputDirectory;
    @MojoParameter(required=false, expression="${project.build.outputDirectory}", description="Set the destination directory for class files (same behaviour of -d option)")
    private File outputClassDirectory;
    @MojoParameter(required=false, expression="${devkit.javadoc.check.skip}", description="Skip JavaDoc validation", defaultValue="false")
    private boolean skipJavaDocValidation;
    @MojoParameter(expression="${category}")
    private String category;

    @Override
    protected File getOutputClassDirectory() {
        return this.outputClassDirectory;
    }

    @Override
    protected String[] getProcessors() {
        return processors;
    }

    @Override
    protected void addCompileSourceRoot(MavenProject project, String dir) {
        project.addCompileSourceRoot(dir);
    }

    @Override
    public File getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    @Override
    protected Set<String> getClasspathElements(Set<String> result) {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource r : resources) {
                result.add(r.getDirectory());
            }
        }
        result.addAll(this.classpathElements);
        return result;
    }

    @Override
    protected void addCompilerArguments(List<String> options) throws MojoExecutionException {
        if (this.skipJavaDocValidation) {
            options.add("-AenableJavaDocValidation=false");
        } else {
            options.add("-AenableJavaDocValidation=true");
        }
        if (this.skipStudioPluginPackage) {
            options.add("-AenabledStudioPluginPackage=false");
        } else {
            options.add("-AenabledStudioPluginPackage=true");
        }
        HashMap<String, Object> mavenInformation = new HashMap<String, Object>();
        File mavenInformationFile = new File(this.defaultOutputDirectory, "maven-information.descriptor");
        mavenInformation.put("mavenGroupId", this.project.getGroupId());
        mavenInformation.put("mavenArtifactId", this.project.getArtifactId());
        mavenInformation.put("mavenVersion", this.project.getVersion());
        mavenInformation.put("mavenName", this.project.getName());
        mavenInformation.put("mavenOutputDirectory", this.defaultOutputDirectory.getPath());
        mavenInformation.put("mavenCategory", this.category);
        List dependencies = this.project.getDependencies();
        ArrayList<String> dependenciesAsString = new ArrayList<String>();
        for (Dependency dependency : dependencies) {
            dependenciesAsString.add(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getScope() + ":" + dependency.isOptional());
        }
        mavenInformation.put("mavenDependencies", dependenciesAsString);
        File licenseFile = new File(this.defaultOutputDirectory, LICENSE_DESCRIPTOR_FILE_NAME);
        MavenLicenseBuilder mavenLicenseBuilder = new MavenLicenseBuilder(this.getLog(), this.project.getBasedir(), this.project.getLicenses());
        MavenLicense mavenLicense = mavenLicenseBuilder.build();
        if (mavenLicense == null) {
            List<String> possibleLicenseFileNames = mavenLicenseBuilder.getPossibleLicenseFileNames();
            throw new MojoExecutionException(String.format("Error!  None of the license files were found in the root directory (%s). Check that you are running your goal online and that the URL in the licenses section of the pom.xml is properly configured.", Arrays.toString(possibleLicenseFileNames.toArray(new String[possibleLicenseFileNames.size()]))));
        }
        SerializationUtils.save((File)licenseFile, (Object)mavenLicense);
        mavenInformation.put("mavenLicense", licenseFile.getAbsolutePath());
        SerializationUtils.save((File)mavenInformationFile, mavenInformation);
        options.add("-AmavenInformationFile=" + mavenInformationFile);
        super.addCompilerArguments(options);
    }
}

