/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.devkit.generation.studio.packaging.ArchiverPlan;
import org.mule.devkit.generation.studio.packaging.PackagePlanExecutor;
import org.mule.devkit.generation.studio.packaging.Placeholder;
import org.mule.devkit.generation.studio.packaging.SignComponent;
import org.mule.devkit.generation.utils.SerializationUtils;
import org.mule.devkit.maven.AbstractMuleMojo;

@MojoPhase(value="package")
@MojoGoal(value="studio-package")
@MojoRequiresDependencyResolution(value="runtime")
public class StudioPackageMojo
extends AbstractMuleMojo {
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @MojoParameter(expression="${keystore.path}", defaultValue="${project.basedir}/keystore.ks")
    private String keystorePath;
    @MojoParameter(expression="${alias}")
    private String alias;
    @MojoParameter(expression="${storepass}")
    private String storepass;
    @MojoParameter(expression="${keypass}")
    private String keypass;
    @MojoComponent
    private P2ApplicationLauncher launcher;
    @MojoComponent
    private P2ApplicationLauncher launcher2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipStudioPluginPackage) {
            return;
        }
        ArchiverPlan archiverPlan = (ArchiverPlan)SerializationUtils.load((File)new File(this.classesDirectory, "package.descriptor"));
        SignComponent signComponent = new SignComponent(this.keystorePath, this.storepass, this.keypass, this.alias);
        PackagePlanExecutor.RelativePathMap pathResolver = new PackagePlanExecutor.RelativePathMap(this.outputDirectory);
        PackagePlanExecutor packagePlanExecutor = new PackagePlanExecutor(pathResolver, signComponent);
        packagePlanExecutor.execute(archiverPlan);
        this.createContentAndArtifacts(pathResolver);
        this.projectHelper.attachArtifact(this.project, "zip", "studio-plugin", this.buildZip(pathResolver));
    }

    private File buildZip(PackagePlanExecutor.RelativePathMap pathResolver) throws MojoExecutionException {
        ZipArchiver archiver = new ZipArchiver();
        File updateSiteDirectory = (File)Placeholder.UPDATE_SITE_DIRECTORY.visit((Placeholder.PlaceholderMap)pathResolver);
        File[] files = updateSiteDirectory.listFiles();
        if (files == null) {
            throw new MojoExecutionException(String.format("Files not found in [%s] (update site directory)", updateSiteDirectory));
        }
        for (File file : files) {
            if (file.isDirectory()) {
                archiver.addDirectory(file, file.getName() + File.separator);
                continue;
            }
            archiver.addFile(file, file.getName());
        }
        File destFile = new File(this.outputDirectory + File.separator + "UpdateSite.zip");
        archiver.setDestFile(destFile);
        if (destFile.exists()) {
            destFile.delete();
        }
        try {
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating the update site zip file: ", (Exception)e);
        }
        return destFile;
    }

    private void createContentAndArtifacts(PackagePlanExecutor.RelativePathMap pathResolver) throws MojoExecutionException {
        try {
            File updateSitePath = (File)Placeholder.UPDATE_SITE_DIRECTORY.visit((Placeholder.PlaceholderMap)pathResolver);
            File classesPath = (File)Placeholder.CLASSES_DIRECTORY.visit((Placeholder.PlaceholderMap)pathResolver);
            String updateSiteURI = updateSitePath.toURI().toString();
            File categoryFile = new File(classesPath, "category.xml").getAbsoluteFile();
            if (!categoryFile.exists()) {
                throw new MojoExecutionException("Error creating update site: category.xml does not exist");
            }
            String categoryXml = categoryFile.toURI().toString();
            int returnCode = this.featuresAndBundles(this.launcher, updateSitePath, updateSiteURI);
            if (returnCode != 0) {
                throw new MojoExecutionException("Error creating update site: Return code " + returnCode);
            }
            returnCode = this.categoryPublisher(this.launcher2, updateSiteURI, categoryXml);
            if (returnCode != 0) {
                throw new MojoExecutionException("Error creating update site: Return code " + returnCode);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create update site", e);
        }
    }

    private int featuresAndBundles(P2ApplicationLauncher launcher, File updateSitePath, String updateSiteURI) {
        launcher.addArguments(new String[]{"-artifactRepository", updateSiteURI});
        launcher.addArguments(new String[]{"-metadataRepository", updateSiteURI});
        launcher.addArguments(new String[]{"-source", updateSitePath.getAbsolutePath()});
        launcher.addArguments(new String[]{"-publishArtifacts", "-append"});
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher");
        return launcher.execute(20);
    }

    private int categoryPublisher(P2ApplicationLauncher launcher, String updateSiteURI, String categoryXml) {
        launcher.addArguments(new String[]{"-categoryDefinition", categoryXml});
        launcher.addArguments(new String[]{"-categoryQualifier"});
        launcher.addArguments(new String[]{"-metadataRepository", updateSiteURI});
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.CategoryPublisher");
        return launcher.execute(20);
    }
}

