/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.maven.studio.StudioFeatureBuilder;
import org.mule.devkit.maven.studio.StudioPluginBuilder;
import org.mule.devkit.maven.studio.StudioSiteXmlBuilder;
import org.mule.util.IOUtils;
import sun.security.tools.JarSigner;

@MojoPhase(value="package")
@MojoGoal(value="studio-package")
@MojoRequiresDependencyResolution(value="runtime")
public class StudioPackageMojo
extends AbstractMuleMojo {
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @MojoParameter(expression="${keystore.path}", defaultValue="${project.basedir}/keystore.ks")
    private String keystorePath;
    @MojoParameter(expression="${alias}")
    private String alias;
    @MojoParameter(expression="${licensePath}", defaultValue="${project.basedir}/studio_license.txt")
    private String licensePath;
    @MojoParameter(expression="${storepass}")
    private String storepass;
    @MojoParameter(expression="${keypass}")
    private String keypass;
    @MojoParameter(expression="${category}")
    private String category;
    @MojoComponent
    private P2ApplicationLauncher launcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipStudioPluginPackage) {
            return;
        }
        String pluginVersion = this.buildVersion();
        String pluginName = this.project.getArtifactId();
        File studioFeature = this.featureBuilderFor(pluginVersion, pluginName).build();
        File studioPlugin = this.pluginBuilderFor(pluginVersion, pluginName).build();
        new StudioSiteXmlBuilder(pluginName, pluginVersion, this.finalName, this.outputDirectory.getPath(), this.classesDirectory, this.category).build();
        this.sign(studioFeature, studioPlugin);
        this.createContentAndArtifacts(pluginName, pluginVersion);
        this.projectHelper.attachArtifact(this.project, "zip", "us", this.buildZip());
    }

    private File buildZip() {
        ZipArchiver archiver = new ZipArchiver();
        File updateSiteDir = new File(this.outputDirectory + File.separator + "update-site" + File.separator);
        for (File file : updateSiteDir.listFiles()) {
            if (file.isDirectory()) {
                archiver.addDirectory(file, file.getName() + File.separator);
                continue;
            }
            archiver.addFile(file, file.getName());
        }
        File destFile = new File(this.outputDirectory + File.separator + "UpdateSite.zip");
        archiver.setDestFile(destFile);
        try {
            destFile.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            // empty catch block
        }
        return destFile;
    }

    private String buildVersion() throws MojoExecutionException {
        String pluginVersion = this.getPluginVersionFrom();
        return pluginVersion + "." + this.buildQualifier();
    }

    private String getPluginVersionFrom() throws MojoExecutionException {
        DefaultArtifactVersion av = new DefaultArtifactVersion(this.project.getVersion());
        int majorVersion = av.getMajorVersion();
        int minorVersion = av.getMinorVersion();
        int incrementalVersion = av.getIncrementalVersion();
        if (majorVersion == 0 && minorVersion == 0 && incrementalVersion == 0) {
            throw new MojoExecutionException("Invalid maven project version, can't create studio plugin version, format must be [major-version].[minor-version].[incremental-version]-[qualifier], at least a major version must be specified.");
        }
        return majorVersion + "." + minorVersion + "." + incrementalVersion;
    }

    private void sign(File studioFeature, File studioPlugin) {
        if (this.keystorePath != null && this.checkExistenceOf(this.keystorePath)) {
            JarSigner jarsigner = new JarSigner();
            List<String> pluginOptions = this.buildOptions(studioPlugin.getPath());
            List<String> featureOptions = this.buildOptions(studioFeature.getPath());
            jarsigner.run(pluginOptions.toArray(new String[0]));
            jarsigner.run(featureOptions.toArray(new String[0]));
        }
    }

    private List<String> buildOptions(String path) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-keystore");
        options.add(this.keystorePath);
        if (this.storepass != null) {
            options.add("-storepass");
            options.add(this.storepass);
        }
        if (this.keypass != null) {
            options.add("-keypass");
            options.add(this.keypass);
        }
        options.add("-verbose");
        options.add(path);
        options.add(this.alias);
        return options;
    }

    private void createContentAndArtifacts(String pluginName, String pluginVersion) throws MojoExecutionException {
        try {
            String updateSitePath = this.outputDirectory + File.separator + "update-site" + File.separator;
            this.launcher.addArguments(new String[]{"-metadataRepository", "file:" + updateSitePath});
            this.launcher.addArguments(new String[]{"-source", updateSitePath});
            this.launcher.addArguments(new String[]{"-artifactRepository", "file:" + updateSitePath});
            this.launcher.addArguments(new String[]{"-publishArtifacts", "-append"});
            this.launcher.addArguments(new String[]{"-site", "file:" + updateSitePath + "site.xml"});
            this.launcher.setApplicationName("org.eclipse.equinox.p2.publisher.EclipseGenerator");
            this.launcher.execute(20);
            String jarName = pluginName + "_" + pluginVersion + ".jar";
            new File(updateSitePath + File.separator + "features" + File.separator + jarName).delete();
            new File(updateSitePath + File.separator + "plugins" + File.separator + jarName).delete();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create update site", e);
        }
    }

    private StudioPluginBuilder pluginBuilderFor(String pluginVersion, String pluginName) {
        return new StudioPluginBuilder(pluginName, pluginVersion, this.finalName, this.outputDirectory.getPath(), this.classesDirectory, this.project.getVersion());
    }

    private StudioFeatureBuilder featureBuilderFor(String pluginVersion, String pluginName) throws MojoExecutionException {
        try {
            File licenseFile;
            String license = "";
            if (this.licensePath != null && (licenseFile = new File(this.licensePath)).exists()) {
                license = IOUtils.toString((InputStream)new FileInputStream(licenseFile));
            }
            return new StudioFeatureBuilder(pluginName, pluginVersion, this.finalName, this.outputDirectory.getPath(), license, this.classesDirectory);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Invalid license Path", (Exception)e);
        }
    }

    private String buildQualifier() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return sdf.format(new Date());
    }

    private boolean checkExistenceOf(String path) {
        return new File(path).exists();
    }
}

