/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.devkit.maven.studio.TokensReplacer;
import org.mule.devkit.maven.studio.UpdateSiteElementsBuilder;
import org.mule.util.FileUtils;

public class StudioSiteXmlBuilder
extends UpdateSiteElementsBuilder {
    private String category;
    private TokensReplacer tokensReplacer;

    StudioSiteXmlBuilder(String pluginName, String pluginVersion, String muleAppName, String outputDirectory, File classesDirectory, String category) {
        super(pluginName, pluginVersion, muleAppName, outputDirectory, classesDirectory);
        this.category = StringUtils.isEmpty((String)category) ? "Connectors" : category;
        this.tokensReplacer = new TokensReplacer(this.buildTokens());
    }

    private Map<String, String> buildTokens() {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("%CATEGORY%", this.category);
        tokens.put("%VERSION%", this.pluginVersion);
        return tokens;
    }

    @Override
    public File build() throws MojoExecutionException {
        File siteXmlFile = new File(this.updateSitePath, "site.xml");
        File file = new File(this.classesDirectory, "site.xml");
        if (!file.exists()) {
            throw new MojoExecutionException("Error while packaging Mule Studio Site: " + file.getName() + " does not exist");
        }
        this.tokensReplacer.replaceTokensOn(file);
        try {
            FileUtils.copyFile((File)file, (File)siteXmlFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while packaging Mule Studio Site: " + file.getName() + " does not exist");
        }
        return siteXmlFile;
    }
}

