/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.devkit.generation.mule.studio.MuleStudioPluginGenerator;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.maven.ModuleArchiver;

@MojoPhase(value="package")
@MojoGoal(value="studio-package")
@MojoRequiresDependencyResolution(value="runtime")
public class StudioPackageMojo
extends AbstractMuleMojo {
    public static final String STUDIO_PACKAGE_SUFFIX = "-studio.zip";
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project.build.outputDirectory}", required=true)
    private File classesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipStudioPluginPackage) {
            return;
        }
        File studioPlugin = new File(this.outputDirectory, this.finalName + STUDIO_PACKAGE_SUFFIX);
        try {
            this.createStudioPlugin(studioPlugin);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", studioPlugin);
    }

    protected void createStudioPlugin(File studioPlugin) throws MojoExecutionException, ArchiverException {
        ModuleArchiver archiver = new ModuleArchiver();
        List attachedArtifacts = this.project.getAttachedArtifacts();
        AttachedArtifact mulePluginZipArtifact = null;
        for (Object object : attachedArtifacts) {
            AttachedArtifact attachedArtifact = (AttachedArtifact)object;
            if (!attachedArtifact.getFile().getName().equals(this.finalName + ".zip")) continue;
            mulePluginZipArtifact = attachedArtifact;
        }
        if (mulePluginZipArtifact == null) {
            throw new MojoExecutionException("Mule Plugin zip file not available");
        }
        archiver.addFile(mulePluginZipArtifact.getFile(), mulePluginZipArtifact.getFile().getName());
        this.addArchivedClasses(archiver, File.separator);
        for (String fileName : MuleStudioPluginGenerator.GENERATED_FILES) {
            File file = new File(this.classesDirectory, fileName);
            if (!file.exists()) {
                throw new MojoExecutionException("Error while packagin Mule Studio plugin: " + file.getName() + " does not exist");
            }
            archiver.addFile(file, file.getPath().substring(file.getPath().indexOf(this.classesDirectory.getPath()) + this.classesDirectory.getPath().length()));
        }
        archiver.addDirectory(new File(this.classesDirectory, "icons/"), "icons/", null, null);
        archiver.setDestFile(studioPlugin);
        try {
            studioPlugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while packaging Studio plugin", (Exception)e);
        }
    }

    private void addArchivedClasses(ModuleArchiver archiver, String directory) throws ArchiverException, MojoExecutionException {
        if (!this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
            return;
        }
        this.getLog().info((CharSequence)"Copying classes as a jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            archiver.addFile(jar, directory + jar.getName());
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            this.getLog().error((CharSequence)"Cannot create project jar", (Throwable)e);
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }
}

