/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.mule.devkit.maven.AbstractMuleMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="filter-resources")
@MojoPhase(value="process-resources")
public class FilterResourcesMojo
extends AbstractMuleMojo {
    @MojoComponent(role="org.apache.maven.shared.filtering.MavenResourcesFiltering", roleHint="default")
    private MavenResourcesFiltering resourceFilter;
    @MojoParameter(expression="${encoding}", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @MojoParameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @MojoParameter(defaultValue="false")
    private boolean filterAppDirectory;
    @MojoParameter(defaultValue="true")
    private boolean escapeWindowsPaths;
    @MojoParameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @MojoParameter
    private List<?> nonFilteredFileExtensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.filterAppDirectory) {
            return;
        }
        this.getLog().info((CharSequence)("filtering resources from " + this.appDirectory.getAbsolutePath()));
        this.filterResources();
    }

    private void filterResources() throws MojoExecutionException {
        try {
            MavenResourcesExecution execution = new MavenResourcesExecution(this.getResources(), this.getFilteredAppDirectory(), this.project, this.encoding, null, null, this.session);
            execution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            execution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            if (this.nonFilteredFileExtensions != null) {
                execution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.resourceFilter.filterResources(execution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error while filtering Mule config files", (Exception)((Object)e));
        }
    }

    private List<Resource> getResources() {
        Resource appFolderResource = new Resource();
        appFolderResource.setDirectory(this.appDirectory.getAbsolutePath());
        appFolderResource.setFiltering(true);
        return Arrays.asList(appFolderResource);
    }
}

