/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.lic.mojo;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;
import org.mule.tools.devkit.lic.security.SignatureHandler;
import org.mule.tools.devkit.lic.security.ZippedBundle;
import org.mule.tools.devkit.lic.template.LicenseInfoTemplate;

@Mojo(name="license", requiresProject=false)
public class LicenseGenerationMojo
extends AbstractMojo {
    @Parameter(required=false, property="vendor.keystore")
    private String keyStore;
    @Parameter(required=false, property="keystore.password")
    private String keystorePassword;
    @Parameter(required=false, property="client")
    private String client;
    @Parameter(required=false, property="entitlement.provider")
    private String providerName;
    @Parameter(required=false, property="connector.name")
    private String connectorName;
    @Parameter(required=false, property="entitlement.name")
    private String feature;
    @Parameter(required=false, property="days.to.expire")
    private String daysToExpiration;
    @Parameter(required=false, property="versions")
    private String validVersions;
    private String keyName;
    private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialise();
        this.keyName = this.providerName + "-" + this.connectorName;
        try {
            char[] password = this.readKeyStorePassword().toCharArray();
            PrivateKey privateKey = KeyHandler.loadPrv(this.keyName, new FileInputStream(this.keyStore), password);
            ZippedBundle bundle = new ZippedBundle(Paths.get(this.connectorName + ".lic", new String[0]).toString());
            byte[] license = new LicenseInfoTemplate(this.feature, this.providerName, this.client, this.daysToExpiration, this.validVersions).build();
            bundle.addEntry(this.connectorName.concat(".info"), new ByteArrayInputStream(license));
            byte[] signedData = SignatureHandler.sign(new ByteArrayInputStream(license), privateKey, "SHA512withRSA");
            bundle.addEntry(this.connectorName.concat(".sig"), new ByteArrayInputStream(signedData));
            bundle.export();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().debug((CharSequence)("- client: " + this.client));
            this.getLog().debug((CharSequence)("- feature: " + this.feature));
            this.getLog().debug((CharSequence)("- keyName: " + this.keyName));
            this.getLog().debug((CharSequence)("- keystore: " + this.keyStore));
            this.getLog().debug((CharSequence)("- providerName: " + this.providerName));
            this.getLog().debug((CharSequence)("- connectorName: " + this.connectorName));
            this.getLog().debug((CharSequence)("- validVersions: " + this.validVersions));
            this.getLog().debug((CharSequence)("- daysToExpiration: " + this.daysToExpiration));
            throw new MojoFailureException("Failed to create a license using the keystore " + this.keyStore + "and the provided data: " + e.getMessage());
        }
    }

    private void initialise() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.readKeyStore()) || !new File(this.keyStore).exists()) {
            throw new MojoFailureException("Invalid path to vendor keyStore");
        }
        if (StringUtils.isBlank((CharSequence)this.providerName) || StringUtils.isBlank((CharSequence)this.connectorName)) {
            this.parseEntitlementInfoFromKeystore();
        }
        if (StringUtils.isBlank((CharSequence)this.readClient())) {
            throw new MojoFailureException("Invalid client name");
        }
        if (StringUtils.isBlank((CharSequence)this.readVendorName())) {
            throw new MojoFailureException("Invalid vendor name");
        }
        if (StringUtils.isBlank((CharSequence)this.readFeature())) {
            throw new MojoFailureException("Invalid feature id");
        }
        if (StringUtils.isBlank((CharSequence)this.readConnectorName())) {
            throw new MojoFailureException("Invalid license name");
        }
        this.daysToExpiration = this.daysToExpiration == null ? "" : this.daysToExpiration;
        String string = this.validVersions = this.validVersions == null ? "" : this.validVersions;
        if (!StringUtils.isBlank((CharSequence)this.validVersions)) {
            Matcher rangeMatcher = Pattern.compile("(\\[|\\()([^,]*),(.*)(\\]|\\))").matcher(this.validVersions);
            if (!rangeMatcher.matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
            Pattern versionPattern = Pattern.compile("^([0-9])\\.([0-9]|x)\\.([0-9]|x)\\-?(.*SNAPSHOT)?$");
            if (!StringUtils.isBlank((CharSequence)rangeMatcher.group(2)) && !versionPattern.matcher(rangeMatcher.group(2)).matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
            if (!StringUtils.isBlank((CharSequence)rangeMatcher.group(3)) && !versionPattern.matcher(rangeMatcher.group(3)).matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
        }
    }

    public String readKeyStore() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.keyStore)) {
            this.keyStore = this.readLine("* Enter the Path to the vendor keystore (.jks) file: ");
        }
        return this.keyStore;
    }

    public String readClient() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.client)) {
            this.client = this.readLine("* Enter the name of the client whom will receive this license: ");
        }
        return this.client;
    }

    public String readVendorName() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.providerName)) {
            this.providerName = this.readLine("* Enter the name of the provider of the Entitlement as it appears in the @RequiresEntitlement annotation: ");
        }
        return this.providerName;
    }

    public String readFeature() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.feature)) {
            this.feature = this.readLine("* Enter the name of the Entitlement as it appears in the @RequiresEntitlement annotation: ");
        }
        return this.feature;
    }

    public String readConnectorName() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.connectorName)) {
            this.connectorName = this.readLine("* Enter the name of the Connector as it appears in the @Connector \"name\" attribute: ");
        }
        return this.connectorName;
    }

    private String readKeyStorePassword() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.keystorePassword)) {
            this.keystorePassword = this.readPassword("* Enter keystore password: ");
        }
        return this.keystorePassword;
    }

    private String readLine(String promptMessage) throws MojoFailureException {
        return System.console() == null ? this.readLineFromBufferedReader(promptMessage) : this.readLineFromConsole(promptMessage);
    }

    private String readPassword(String promptMessage) throws MojoFailureException {
        return System.console() == null ? this.readLineFromBufferedReader(promptMessage) : this.readPasswordFromConsole(promptMessage);
    }

    private String readLineFromConsole(String promptMessage) {
        return StringUtils.trim((String)System.console().readLine(promptMessage, new Object[0]));
    }

    private String readLineFromBufferedReader(String promptMessage) throws MojoFailureException {
        try {
            System.out.print(promptMessage);
            System.out.flush();
            return StringUtils.trim((String)this.reader.readLine());
        }
        catch (IOException e) {
            throw new MojoFailureException("There was an error reading user input.");
        }
    }

    private String readPasswordFromConsole(String promptMessage) {
        return new String(System.console().readPassword(promptMessage, new Object[0]));
    }

    private void parseEntitlementInfoFromKeystore() {
        if (StringUtils.isBlank((CharSequence)this.keyStore)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.providerName) && StringUtils.isBlank((CharSequence)this.connectorName)) {
            this.getLog().debug((CharSequence)"Loading providerName and connectorName from keystore file");
            String[] names = StringUtils.split((String)this.keyStore, (String)"-");
            if (names != null && names.length == 2) {
                this.providerName = names[0];
                this.connectorName = names[1].replace(".jks", "");
            } else {
                this.getLog().debug((CharSequence)"Failed to infer provider and connector names. Too many parts separated by '-'");
            }
        } else if (!StringUtils.isBlank((CharSequence)this.providerName)) {
            this.getLog().debug((CharSequence)"Loading connectorName from keystore file");
            this.connectorName = StringUtils.replace((String)this.keyStore, (String)(this.providerName + "-"), (String)"").replace(".jks", "");
        } else {
            this.getLog().debug((CharSequence)"Loading providerName from keystore file");
            this.providerName = StringUtils.replace((String)this.keyStore, (String)("-" + this.connectorName), (String)"").replace(".jks", "");
        }
    }
}

