/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.lic.mojo;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.mojo.AbstractSecurityMojo;
import org.mule.tools.devkit.lic.security.KeyHandler;

@Mojo(name="decrypt", requiresProject=false)
public class FileDecryptMojo
extends AbstractSecurityMojo {
    @Parameter(property="use.pub", defaultValue="false")
    private boolean usePublic;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        try {
            byte[] decryptedData = KeyHandler.decrypt(Files.readAllBytes(Paths.get(this.data, new String[0])), this.getKey(this.usePublic));
            FileUtils.writeByteArrayToFile((File)new File(FilenameUtils.getName((String)this.data) + ".dec"), (byte[])decryptedData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to decrypt " + this.data + " with the keystore " + this.keystore);
        }
    }
}

