/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.template;

import java.util.Properties;

/**
 * @author MuleSoft, Inc
 */
public class LicenseInfoTemplate extends AbstractInfoTemplate {

    /* Example License:
                vendor.name=Splunk
                license.owner=ThugLife Inc
                creation.date=06061944
                expiration.date=12102015
                valid.versions=1.0.0-3.3.0
                feature.name=splunkLog
    */
    public static final String FEATURE_KEY = "feature.name";
    public static final String OWNER_NAME_KEY = "license.owner";
    public static final String VERSIONS_KEY = "valid.versions";

    private final String feature;
    private final String licenseOwner;

    public LicenseInfoTemplate(String feature, String vendor, String client, String daysToExpiration, String validVersions) {
        super(vendor, daysToExpiration, validVersions);
        this.feature = feature;
        this.licenseOwner = client;
    }

    public byte[] build() {

        Properties lic = new Properties();
        lic.setProperty(FEATURE_KEY, feature);
        lic.setProperty(VENDOR_NAME_KEY, vendorName);
        lic.setProperty(OWNER_NAME_KEY, licenseOwner);
        lic.setProperty(CREATION_DATE_KEY, creationDate);
        lic.setProperty(EXPIRATION_DATE_KEY, expirationDate);
        lic.setProperty(VERSIONS_KEY, validVersions);

        return build(lic);
    }
}
