/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;


import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;
import org.mule.tools.devkit.lic.security.SignatureHandler;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

@Mojo(name = "verify", requiresProject = false)
public class SignVerifierMojo extends AbstractMojo {

    /**
     * Signature file corresponding to 'info' file being signed with the private key that corresponds with the given 'publicKey'
     */
    @Parameter(required = true, property="signature")
    private String signatureFile;

    @Parameter(required = true, property="keystore")
    protected String keystore;

    @Parameter(required = true, property="key.name")
    protected String alias;

    @Parameter(required = true, property="data")
    protected String data;

    public void execute() throws MojoExecutionException, MojoFailureException {

        if (StringUtils.isBlank(keystore) || !Files.exists(Paths.get(keystore))){
            throw new MojoFailureException("Invalid keystore file: " + keystore);
        }

        if (StringUtils.isBlank(data) || !Files.exists(Paths.get(data))){
            throw new MojoFailureException("Invalid data file: " + data);
        }

        boolean verified;
        try {
            char[] password = System.console().readPassword("* Enter keystore password: ");
            verified = SignatureHandler.verify(signatureFile, KeyHandler.loadPub(alias, new FileInputStream(keystore), password), data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to verify signature of " + data + " with the keystore " + keystore);
        }

        if (!verified){
            throw new MojoFailureException(String.format(
                    "Signature of Data file [%s] using the keystore [%s] does not match the expected signature", data, keystore));
        } else {
            getLog().info("Signature is a match!");
        }
    }
}
