/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;

import java.io.FileInputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.security.Key;

/**
* @author MuleSoft, Inc
*/
public abstract class AbstractSecurityMojo extends AbstractMojo {

    @Parameter(required = true, property="keystore")
    protected String keystore;

    @Parameter(required = true, property="key.name")
    protected String alias;

    @Parameter(required = true, property="data")
    protected String data;

    public void execute() throws MojoExecutionException, MojoFailureException {
        validateFile(data);
        validateFile(keystore);

        if (StringUtils.isBlank(alias)) {
            throw new MojoExecutionException("[key.name] cannot be null or empty");
        }
    }

    protected Key getKey(boolean usePublic) throws Exception {
        char[] password = System.console().readPassword("* Enter keystore password: ");
        if (usePublic){
            return KeyHandler.loadPub(alias, new FileInputStream(keystore), password);
        }
        return KeyHandler.loadPrv(alias, new FileInputStream(keystore), password);
    }

    protected void validateFile(String path) throws MojoExecutionException {
        try {
            if (!Paths.get(path).toFile().exists()) {
                throw new MojoExecutionException("Invalid file: " + path);
            }
        } catch (InvalidPathException e){
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }



}
