/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.template;

import java.util.Properties;

/**
 * @author MuleSoft, Inc
 */
public class VendorInfoTemplate extends AbstractInfoTemplate {

    /*
        vendor.name=
        connector.name=
        creation.date=
        expiration.date=
        valid.versions=
        contact.email=
        contact.message=
    */

    public static final String CONNECTOR_NAME_KEY = "connector.name";
    public static final String EMAIL_KEY = "contact.email";
    public static final String CONTACT_MESSAGE_KEY = "contact.message";

    private String contactEemail;
    private String contactMessage;
    private String connectorName;

    public VendorInfoTemplate(String vendorName, String connectorName, String daysToExpiration, String validVersions, String contactEemail, String contactMessage) {
        super(vendorName, daysToExpiration, validVersions);
        this.contactEemail = contactEemail;
        this.contactMessage = contactMessage;
        this.connectorName = connectorName;
    }

    public byte[] build() {

        Properties info = new Properties();
        info.setProperty(VENDOR_NAME_KEY, vendorName);
        info.setProperty(CONNECTOR_NAME_KEY, connectorName);
        info.setProperty(CREATION_DATE_KEY, creationDate);
        info.setProperty(EXPIRATION_DATE_KEY, expirationDate);
        info.setProperty(VERSIONS_KEY, validVersions);
        info.setProperty(EMAIL_KEY, contactEemail);
        info.setProperty(CONTACT_MESSAGE_KEY, contactMessage);

        return build(info);
    }

}
