/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.template;

import org.apache.commons.lang3.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

/**
 * @author MuleSoft, Inc
 */
public abstract class AbstractInfoTemplate {

    public static final String DATE_FORMAT = "ddMMyyyy";
    public static final int DEFAULT_EXPIRATION_DAYS = 365;

    public static final String VENDOR_NAME_KEY = "vendor.name";
    public static final String CREATION_DATE_KEY = "creation.date";
    public static final String EXPIRATION_DATE_KEY = "expiration.date";
    public static final String VERSIONS_KEY = "valid.versions";
    public static final String NO_EXPIRATION = "";

    protected String vendorName;
    protected String creationDate;
    protected String expirationDate;
    protected String validVersions;

    public AbstractInfoTemplate(String vendorName, String daysToExpiration, String validVersions) {
        this.vendorName = vendorName;
        this.creationDate = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        this.expirationDate = calculateExpirationDate(daysToExpiration);
        this.validVersions = validVersions;
    }

    protected String calculateExpirationDate(String expirationDays) {
        int daysInFuture = StringUtils.isBlank(expirationDays) ? DEFAULT_EXPIRATION_DAYS : Integer.parseInt(expirationDays);

        if (daysInFuture < 1){
            return NO_EXPIRATION;
        }

        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(Calendar.DAY_OF_YEAR, daysInFuture);
        return new SimpleDateFormat(DATE_FORMAT).format(c.getTime());
    }

    protected byte[] build(Properties info){

        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            info.store(os, "");
            return os.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}
