/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.security;

import java.io.*;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

/**
 * @author MuleSoft, Inc
 */
public class SignatureHandler {

    private static final String SHA_512_WITH_RSA = "SHA512withRSA";

    public static byte[] sign(InputStream data, PrivateKey privateKey, String algorithm) throws Exception {

        Signature sigWriter = Signature.getInstance(algorithm);
        sigWriter.initSign(privateKey);

        BufferedInputStream bufin = new BufferedInputStream(data);
        byte[] buffer = new byte[1024];
        int len;
        while ((len = bufin.read(buffer)) >= 0) {
            sigWriter.update(buffer, 0, len);
        }
        bufin.close();

        return sigWriter.sign();
    }

    public static boolean verify(String signatureFile, PublicKey publicKey, String dataFile) throws Exception {

        Signature signatureVerifier = Signature.getInstance(SHA_512_WITH_RSA);
        signatureVerifier.initVerify(publicKey);

        byte[] sigToVerify = loadSignature(signatureFile);

        loadDataToVerify(dataFile, signatureVerifier);

        return signatureVerifier.verify(sigToVerify);
    }


    public static byte[] loadSignature(String signatureFile) throws IOException {
        InputStream sigIS = new FileInputStream(signatureFile);
        byte[] sigToVerify = new byte[sigIS.available()];
        sigIS.read(sigToVerify);
        sigIS.close();
        return sigToVerify;
    }


    private static void loadDataToVerify(String dataFile, Signature signReader) throws IOException, SignatureException {
        InputStream dataIS = new FileInputStream(dataFile);
        int len;
        byte[] buffer = new byte[1024];
        BufferedInputStream bufin = new BufferedInputStream(dataIS);
        while (bufin.available() != 0) {
            len = bufin.read(buffer);
            signReader.update(buffer, 0, len);
        }
        bufin.close();
    }

}
