/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea.compiler;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.idea.compiler.MuleAptGenerationItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MuleAptPrepareAction
implements Computable<GeneratingCompiler.GenerationItem[]> {
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];
    private static final Logger LOG = Logger.getInstance((String)MuleAptPrepareAction.class.getName());
    private final CompileContext myContext;

    public MuleAptPrepareAction(CompileContext context) {
        this.myContext = context;
    }

    public GeneratingCompiler.GenerationItem[] compute() {
        if (this.myContext.getProject().isDisposed()) {
            return EMPTY_GENERATION_ITEM_ARRAY;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myContext.getProject());
        ArrayList<MuleAptGenerationItem> items = new ArrayList<MuleAptGenerationItem>();
        for (VirtualFile sourceRoot : rootManager.getContentSourceRoots()) {
            for (VirtualFile muleModule : this.getModules(sourceRoot)) {
                for (Module mod : modules) {
                    if (!mod.getModuleScope().contains(muleModule)) continue;
                    items.add(new MuleAptGenerationItem(muleModule, mod));
                }
            }
        }
        return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
    }

    private List<VirtualFile> getModules(VirtualFile virtualFile) {
        ArrayList<VirtualFile> ret = new ArrayList<VirtualFile>();
        if (virtualFile.getName().endsWith(".java")) {
            String content = null;
            try {
                content = new String(virtualFile.contentsToByteArray());
            }
            catch (IOException e) {
                LOG.error("Cannot parse content for " + virtualFile.getName());
            }
            if (content != null && (content.contains("@Module") || content.contains("@Connector"))) {
                ret.add(virtualFile);
            }
        }
        for (VirtualFile child : virtualFile.getChildren()) {
            ret.addAll(this.getModules(child));
        }
        return ret;
    }
}

