/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class VersionUtils {
    protected static String buildQualifier(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return sdf.format(d);
    }

    public static String buildQualifier() {
        return VersionUtils.buildQualifier(new Date());
    }

    public static String getPluginVersionFrom(String versionString) {
        Version av = Version.parseVersion(versionString);
        int majorVersion = av.getMajorVersion();
        int minorVersion = av.getMinorVersion();
        int incrementalVersion = av.getIncrementalVersion();
        if (majorVersion == 0 && minorVersion == 0 && incrementalVersion == 0) {
            throw new RuntimeException("Invalid maven project version, can't create studio plugin version, format must be [major-version].[minor-version].[incremental-version]-[qualifier], at least a major version must be specified.");
        }
        return majorVersion + "." + minorVersion + "." + incrementalVersion;
    }

    public static String buildVersion(String version) {
        String pluginVersion = VersionUtils.getPluginVersionFrom(version);
        return pluginVersion + "." + VersionUtils.buildQualifier();
    }

    public static class Version {
        private Integer buildNumber;
        private String qualifier;
        private Integer majorVersion;
        private Integer minorVersion;
        private Integer incrementalVersion;

        public static Version parseVersion(String versionString) {
            String part1;
            Version version = new Version();
            int index = versionString.indexOf("-");
            String part2 = null;
            if (index < 0) {
                part1 = versionString;
            } else {
                part1 = versionString.substring(0, index);
                part2 = versionString.substring(index + 1);
            }
            if (part2 != null) {
                try {
                    if (part2.length() == 1 || !part2.startsWith("0")) {
                        version.buildNumber = Integer.valueOf(part2);
                    } else {
                        version.qualifier = part2;
                    }
                }
                catch (NumberFormatException e) {
                    version.qualifier = part2;
                }
            }
            if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
                try {
                    version.majorVersion = Integer.valueOf(part1);
                }
                catch (NumberFormatException e) {
                    version.qualifier = versionString;
                    version.buildNumber = null;
                }
            } else {
                boolean fallback = false;
                StringTokenizer tok = new StringTokenizer(part1, ".");
                try {
                    version.majorVersion = Version.getNextIntegerToken(tok);
                    if (tok.hasMoreTokens()) {
                        version.minorVersion = Version.getNextIntegerToken(tok);
                    }
                    if (tok.hasMoreTokens()) {
                        version.incrementalVersion = Version.getNextIntegerToken(tok);
                    }
                    if (tok.hasMoreTokens()) {
                        fallback = true;
                    }
                    if (part1.indexOf("..") >= 0 || part1.startsWith(".") || part1.endsWith(".")) {
                        fallback = true;
                    }
                }
                catch (NumberFormatException e) {
                    fallback = true;
                }
                if (fallback) {
                    version.qualifier = versionString;
                    version.majorVersion = null;
                    version.minorVersion = null;
                    version.incrementalVersion = null;
                    version.buildNumber = null;
                }
            }
            return version;
        }

        private static Integer getNextIntegerToken(StringTokenizer tok) {
            String s = tok.nextToken();
            if (s.length() > 1 && s.startsWith("0")) {
                throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
            }
            return Integer.valueOf(s);
        }

        public int getMajorVersion() {
            return this.majorVersion != null ? this.majorVersion : 0;
        }

        public int getMinorVersion() {
            return this.minorVersion != null ? this.minorVersion : 0;
        }

        public int getIncrementalVersion() {
            return this.incrementalVersion != null ? this.incrementalVersion : 0;
        }
    }
}

