/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.devkit.generation.api;

import org.mule.devkit.model.Identifiable;

public class PostProcessorException extends Exception {
    private Identifiable element;

    public PostProcessorException(Identifiable element) {
        super();

        this.element = element;
    }

    public PostProcessorException(Identifiable element, String s) {
        super(s);

        this.element = element;
    }

    public PostProcessorException(Identifiable element, String s, Throwable throwable) {
        super(s, throwable);

        this.element = element;
    }


    public PostProcessorException(Identifiable element, Throwable throwable) {
        super(throwable);

        this.element = element;
    }

    public Identifiable getElement() {
        return element;
    }
}
