/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api;

import org.mule.devkit.generation.api.gatherer.Details;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Notification;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;

import java.util.List;

/**
 * Base Module Annotation Verifier
 */
public abstract class AbstractBaseAnnotationVerifier implements ModuleAnnotationVerifier{

    private NotificationGatherer gatherer;

    public NotificationGatherer getGatherer() {
        if( gatherer == null )
            return new DummyGatherer();
        return gatherer;
    }

    public void setGatherer(NotificationGatherer gatherer) {
        this.gatherer = gatherer;
    }

    class DummyGatherer implements  NotificationGatherer{

        private void logWarning(){
            System.out.println("Gatherer not set");
        }


        @Override
        public List<Notification> getNotifications() {
            logWarning();
            return null;
        }

        @Override
        public boolean hasNotifications() {
            logWarning();
            return false;
        }

        @Override
        public List<Notification> getErrors() {
            logWarning();
            return null;
        }

        @Override
        public List<Notification> getWarnings() {
            logWarning();
            return null;
        }

        @Override
        public List<Notification> getNotes() {
            return null;
        }

        @Override
        public boolean hasErrors() {
            logWarning();
            return false;
        }

        @Override
        public boolean hasWarnings() {
            logWarning();
            return false;
        }

        @Override
        public boolean hasNotes() {
            logWarning();
            return false;
        }

        @Override
        public void error(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void warn(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void note(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void errorAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void warnAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void noteAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }
    }
}
