/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api;

/**
 * An enum that stores a list of valid categories that a connector can be assigned to.
 * A category is set by default when creating a new connector, however users can
 * configure this inside the pom.xml file as follows:
 * 
 * <properties>
 * 		...
 * 		<category>Community</category>
 * 		...
 * </properties>
 */
public enum ConnectorCategory {
		
	COMMUNITY("Community"),
	CERTIFIED("Certified"),
	SELECT("Select"),
	PREMIUM("Premium");
	
	private ConnectorCategory(String literal) {
		this.category = literal;
	}

	private String category;
	
	public String getCategory() {
		return category;
	}
	
	public static String[] getValidCategories() {
		return new String[] {
			COMMUNITY.getCategory(),
			CERTIFIED.getCategory(),
			SELECT.getCategory(),
			PREMIUM.getCategory()
		};
	}

}
