/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api.gatherer;

/**
 * Notification that will be show to the user.
 */
public class Notification {
    private NotificationLevel level;
    private Details details;

    public Notification() {
        this.level = NotificationLevel.ERROR;
        this.details = null;
    }

    public Notification(Details details) {
        this.level = NotificationLevel.ERROR;
        this.details = details;
    }
    public Notification(Details details,NotificationLevel level) {
        this.level = level;
        this.details = details;
    }

    public NotificationLevel getLevel() {
        return level;
    }

    public void setLevel(NotificationLevel level) {
        this.level = level;
    }

    public Details getDetails() {
        return details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Notification)) return false;

        Notification that = (Notification) o;

        if (details != null ? !details.equals(that.details) : that.details != null) return false;
        if (level != that.level) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = level != null ? level.hashCode() : 0;
        result = 31 * result + (details != null ? details.hashCode() : 0);
        return result;
    }
}
