/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api.gatherer;

import org.apache.commons.lang.StringUtils;
import org.mule.streaming.ProviderAwarePagingDelegate;

/**
 * Known errors that can have hints or messages.
 */
public enum Message implements DevkitNotification {
    /**
     * Unexpected error: [%s]
     */
    UNEXPECTED_ERROR("Unexpected error: [%s]"),
    MODULE_CONNECTOR_ASSIGNED_TO_INTERFACE("@Module/@Connector cannot be applied to an interface."),
    MODULE_CONNECTOR_CANNOT_HAVE_TYPE_PARAMS("@Module/@Connector type cannot have type parameters."),
    MODULE_CONNECTOR_MUST_BE_PUBLIC("@Module/@Connector must be public."),
    CONFIGURABLE_CANNOT_BE_FINAL("@Configurable cannot be applied to field with final modifier."),
    CONFIGURABLE_CANNOT_BE_STATIC("@Configurable cannot be applied to field with static modifier."),
    CONFIGURABLE_CANNOT_BE_ARRAY("@Configurable cannot be applied to arrays."),
    CONFIGURABLE_USES_RESERVED_IDENTIFIER("@Configurable cannot be applied to field identified by [%s]. [%s] is a reserved identifier."),
    CONFIGURABLE_MISSING_GETTER("@Configurable field identified by [%s] should have a public getter."),
    CONFIGURABLE_MISSING_SETTER("@Configurable field identified by [%s] should have a public setter."),
    CONFIGURABLE_OPTIONAL_CANNOT_BE_PRIMITIVE("@Optional @Configurable fields can not be applied to primitive types without a @Default value. Add a @Default value or change the field type to a non-primitive kind."),
    OPTIONAL_REDUNDANT("When using @Default, the @Optional annotation is redundant (@Default implies @Optional). If possible, discard the @Optional in the field [%s]."),
    DEFAULT_ENUM_NOT_VALID("@Default value is not valid for this enum, check the enum declaration."),
    PLACEMENT_GROUP_ERROR("@Placement's group field value cannot be of \"Basic Settings\""),
    DEFAULT_VALUE_CANNOT_BE_PAYLOAD_MORE_THAN_ONCE("@Default(#[payload])/@Payload cannot be annotated in more than one parameter"),
    REQUIRED_CLASSES_NOT_FOUND("The following classes are not available check your build order as they might be generated later from a WSDL or a XSD file: [%s]."),
    MODULE_CANNOT_HAVE_CONNECT("@Connect methods not allowed for @Module classes, use class level annotation @Connector instead."),
    MODULE_CANNOT_HAVE_VALIDATE_CONNECTION("@ValidateConnection methods not allowed for @Module classes, use class level annotation @Connector instead."),
    MODULE_CANNOT_HAVE_DISCONNECT("@Disconnect methods not allowed for @Module classes, use class level annotation @Connector instead."),
    MODULE_CANNOT_HAVE_CONNECTION_IDENTIFIER("@ConnectionIdentifier methods not allowed for @Module classes, use class level annotation @Connector instead."),
    CONNECTOR_MISSING_CONNECTION_METHODS("@Connector either needs to have all 4 connection methods (@Connect, @Disconnect, @ConnectionIdentifier and @ValidateConnection), or any of them. There were only implemented: %s."),
    CONNECTION_MANAGEMENT_MISSING_CONNECTION_METHODS("@ConnectionManagement needs to implement all connection methods (@Connect, @Disconnect, @ConnectionIdentifier and @ValidateConnection). %s missing"),
    CONNECTOR_USES_CONN_MGMT_AND_OAUTH("The [%s] is trying to implement Connection Management as well as OAuth/OAuth2 in the same class. In order to implement both strategies (connection management + oauth) please read the @Config documentation in https://www.mulesoft.org/documentation/display/36X/Connector+Migration+Guide+-+Mule+3.5+to+3.6."),
    CONNECT_ONE_METHOD_ONLY("You can only have one method annotated with @Connect."),
    CONNECT_MUST_BE_PUBLIC("@Connect method must be public."),
    CONNECT_MUST_THROW_CONNECTION_EXCEPTION("@Connect method must throw ConnectionException."),
    CONNECT_NO_RETURN("@Connect method cannot return anything."),
    CONNECT_MUST_BE_TEST_CONNECTIVITY("@Connect method must be also annotated with @TestConnectivity. If you want to disable test connectivity in Studio, then use @TestConnectivity(active=false)."),
    CONNECT_PARAM_RESTRICTED_TYPES("Parameter [%s] in the @Connect method can not be an [%s] type. Use a @Configurable instead."),
    TEST_CONNECTIVITY_ONE_METHOD_ONLY("You can only have one method annotated with @TestConnectivity."),
    TEST_CONNECTIVITY_MUST_BE_PUBLIC("@TestConnectivity method must be public."),
    TEST_CONNECTIVITY_MUST_THROW_CONNECTION_EXCEPTION("@TestConnectivity method must throw ConnectionException."),
    TEST_CONNECTIVITY_NO_RETURN("@TestConnectivity method cannot return anything."),
    TEST_CONNECTIVITY_ZERO_PARAM("@TestConnectivity method must have zero parameters."),
    TEST_CONNECTIVITY_INVALID_PARAMS("@TestConnectivity method must have the same parameters than @Connect method has, in the same order. Found [%s], but expected [%s]"),
    TEST_CONNECTIVITY_ANNOTATION_MUST_BE_USED("Using connectivityTesting in @Connector/@Module is no longer supported, please use the @TestConnectivity annotation instead, and choose ConnectivityTesting._DEPRECATED as default value for the current connector."),
    CONNECTOR_USES_RESERVED_IDENTIFIER("@Connector method cannot contain a parameter identified by [%s]. [%s] is a reserved identifier."),
    CONNECTOR_MISSING_CONNECTION_KEY_PARAM("@Connect method must have at least one parameter annotated with @ConnectionKey."),
    DISCONNECT_ONE_METHOD_ONLY("You can only have one method annotated with @Disconnect."),
    DISCONNECT_MUST_BE_PUBLIC("@Disconnect method must be public."),
    DISCONNECT_NO_ARGS("The @Disconnect method cannot receive any arguments."),
    DISCONNECT_THROW("The @Disconnect method can only throw RuntimeException."),
    VALIDATE_CONNECTION_ONE_METHOD_ONLY("You can only have one method annotated with @ValidateConnection"),
    VALIDATE_CONNECTION_PUBLIC("@ValidateConnection method must be public."),
    VALIDATE_CONNECTION_MUST_RETURN_BOOLEAN("@ValidateConnection method must return a boolean."),
    VALIDATE_CONNECTION_NO_ARGS("The @ValidateConnection method cannot receive any arguments."),
    CONN_IDENTIFIER_ONE_METHOD_ONLY("You can only have one method annotated with @ConnectionIdentifier"),
    CONN_IDENTIFIER_MUST_RETURN_STRING("@ConnectionIdentifier must return java.lang.String."),
    CONN_IDENTIFIER_MUST_BE_PUBLIC("@ConnectionIdentifier method must be public."),
    CONN_IDENTIFIER_MUST_BE_STATIC("@ConnectionIdentifier cannot be static."),
    CONN_IDENTIFIER_NO_ARGS("The @ConnectionIdentifier method cannot receive any arguments"),
    PARAMETER_ALREADY_PRESENT("Parameter [%s] clash with already defined @Connect parameter."),
    INJECT_CANNOT_INJECT("I don't know how to inject the type [%s] in field [%s]. "
            + "The only types I know how to inject are: MuleContext, ObjectStoreManager, ObjectStore, TransactionManager, QueueManager, MuleConfiguration, LifecycleManager, ClassLoader,"
            + "ExpressionManager, EndpointFactory, MuleClient, SystemExceptionHandler, SecurityManager, WorkManager, Registry, MuleRegistry."),
    INJECT_MISSING_SETTER("Cannot find a setter method for [%s] but its being marked as injectable."),
    INJECT_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked as an injectable Object Store."),
    METHOD_NAME_INVALID("The method name [%s] is not valid for a no-arg non-private method. Reserved names are: [%s]."),
    METHOD_ANNOTATED_MORE_THAN_ONE("Cannot have more than one method annotated with [%s]."),
    CANNOT_BE_NULL_NOR_EMPTY("The value of [%s] cannot be null nor empty."),
    ANNOTATED_METHOD_NO_PARAMS("A method annotated with [%s] cannot receive any parameters."),
    ANNOTATED_METHOD_RETURN_VOID("A method annotated with [%s] can only return void."),
    ANNOTATED_METHOD_RETURN_TYPE("A method annotated with [%s] can only return [%s]."),
    ANNOTATED_METHOD_CANNOT_BE_STATIC("A method annotated with [%s] cannot be static."),
    ANNOTATED_METHOD_MUST_BE_PUBLIC("A method annotated with [%s] can only be public."),
    METADATARETRIEVER_MUST_BE_PUBLIC("@%s method must be public."),
    METADATARETRIEVER_INVALID_METHOD_SIGNATURE("@%s method must have one only argument of type MetaDataKey or ComposedMetaDataKey."),
    METADATARETRIEVER_INVALID_METHOD_SIGNATURE_COMPOSED_KEY_REQUIRED("@%s method must have one only argument of type ComposedMetaDataKey to match the @MetaDataKeyRetriever declaration."),
    METADATAKEYRETRIEVER_INVALID_METHOD_SIGNATURE_COMPOSED_KEY_REQUIRED("@MetaDataKeyRetriever method must return a List<ComposedMetaDataKey> in order to use a [%s] as keySeparator."),
    METADATAKEYRETRIEVER_INCONSISTENT_WITH_METADATARETRIEVER("@MetaDataKeyRetriever method must return a List<ComposedMetaDataKey> to match the @MetaDataRetriever declaration, or must modify @MetaDataRetriever to receive a simple MetaDataKey."),
    METADATARETRIEVER_INVALID_RETURN_TYPE("%s method must return a MetaData object."),
    METADATAKEYRETRIEVER_MUST_BE_PUBLIC("@MetaDataKeyRetriever method must be public."),
    METADATAKEYRETRIEVER_NO_ARGS("@MetaDataKeyRetriever method must not have any arguments."),
    METADATAKEYRETRIEVER_INVALID_RETURN_TYPE("@MetaDataKeyRetriever method must return a List<MetaDataKey> or List<ComposedMetaDataKey>."),
    METADATASTATICKEY_ONE_ONLY("You cannot have more than one @MetaDataStaticKey annotation in each method, [%s] were found."),
    METADATASTATICKEY_INCORRECT_USAGE("When @MetaDataStaticKey is used, there must be in a @Default(\"#[payload]\")."),
    METADATAKEYPARAM_MORE_THAN_ONE("You cannot have more than one @MetaDataKeyParam annotation in each method, [%s] were found."),
    METADATAKEYPARAM_AUTO_NO_PARAM("When @MetaDataKeyParam is used along with AUTO, @MetaDataStaticKey can not be used in a parameter."),
    METADATAKEYPARAM_AUTO_CANNOT_BE_USED_AT_METHOD_LEVEL("When @MetaDataKeyParam is used along with AUTO, @MetaDataStaticKey can not be used at method level."),
    METADATASTATICKEY_VALUE_NULL_OR_EMPTY("When using @MetaDataStaticKey the value of the type attribute must not be null nor empty string."),
    METADATAKEYPARAM_INCORRECT_USAGE("When @MetaDataKeyParam is used along with INPUT or BOTH, there must be a @Optional @Default(\"#[payload]\") parameter."),
    METADATAKEYPARAM_NO_METADATASTATICKEY_PARAM("When @MetaDataKeyParam is used along with INPUT or BOTH, @MetaDataStaticKey can not be used in a parameter."),
    METADATAKEYPARAM_INVALID_RETURN_TYPE("When @MetaDataKeyParam is used along with OUTPUT or BOTH, the return type of the method can not be void."),
    METADATAKEYPARAM_NO_METADATASTATICKEY_METHOD_LEVEL("When @MetaDataKeyParam is used along with OUTPUT or BOTH, @MetaDataStaticKey can not be used at method level."),
    METADATA_RESERVED_NAME("The current name [%s] is reserved, please change it to a different one."),
    METADATASCOPE_CANNOT_BE_USED_ON_MODULES("@Modules can not use @MetaDataScope. The [%s] @Module is using the following @MetaDataCategories [%s]."),
    METADATACATEGORY_REQUIRES_CONNECTOR_CLASS("There must be one @Inject field, and the type should be of an annotated Connector class."),
    INJECT_NOT_INTERFACE_OR_FINAL("The injected field [%s] must not be an interface nor final."),
    NO_ARGS_CONSTRUCTOR_REQUIRED("There must be a constructor without arguments."),
    METADATACATEGORY_CLASS_MUST_BE_PUBLIC_NON_ABSTRACT("The @MetaDataCategory annotated class must be public and non abstract"),
    METADATACATEGORY_REPEATED_SIMPLE_NAMES("@MetaDataCategory annotated classes must not repeat their simple name. For [%s] are [%s] different classes:[%s]."),
    PROCESSOR_PARAM_NAME_SAME_AS_CON_MANAGEMENT_CONNECT_PARAM("@Processor parameter name cannot be equals to any @Connect method parameter name from a @ConnectionManagement Annotated with @OverrideAtProcessors"),
    PARAMETER_SHOULD_BE_CONCRETE_CLASS("parameter should be a Concrete Class parameter or it must be annotated with the @RefOnly annotation"),
    METADATA_REQUIRES_MIN_MULE_340("MetaData is only available for @Connectors with a min mule version of 3.4."),
    METADATACATEGORY_NOT_ALLOWED("When annotating a @Connector with @MetaDataRetriever and @MetaDataKeyRetriever, @MetaDataCategory is not allowed."),
    METADATACATEGORY_INJECTED_FIELD_IS_NOT_CONNECTOR("The connector [%s] uses the category [%s], but the injected field [%s] of the category its not a assignable from the connector type class ([%s] is not the same type as [%s], nor a subclass of it)"),
    METADATACATEGORY_CACHE_FIELD_IS_NOT_METADATACACHE("The connector [%s] uses the category [%s], but the declared cache field [%s] of the category its not of type [%s]"),
    PROCESSORS_NO_METADATASCOPE("There are @Processors who were not annotated with @MetaDataScope. Either annotate them all, or annotate a default one at @Connector level. Full processors list: [%s]"),
    METADATAKEYRETRIEVER_MISSING_FROM_MODULE("The module [%s] must have a method annotated with @MetaDataKeyRetriever."),
    METADATARETRIEVER_MISSING_FROM_MODULE("The module [%s] must have a method annotated with @MetaDataRetriever."),
    MULTIPLE_ANNOTATIONS_FOUND("There must be only one annotated method with [%s] within a class, but [%s] were found. Remove this method or the other ones using the specified annotation."),
    METADATAOUTPUTRETRIEVER_INCORRECT_USAGE("@MetaDataOutputRetriever will only work when used within @MetaDataCategory. Please, remove the method or create a category."),
    METADATARETRIEVER_NOT_DEFINED_FOR_METADATAKEYPARAM("Connector is no DataSense enabled, no @MetaDataRetriever defined in order to lookup for @MetaDataKeyParam in [%s] method."),
    METADATARETRIEVER_NOT_DEFINED_FOR_METADATASTATICKEY("Connector is no DataSense enabled, no @MetaDataRetriever defined in order to lookup for @MetaDataStaticKey in [%s] method."),
    METADATARETRIEVER_NOT_DEFINED_FOR_QUERY_METHOD("Connector is no DataSense enabled, no @MetaDataRetriever defined in order to lookup for parameter [%s] annotated @Query descriptions in [%s] method."),
    METADATASCOPE_INCORRECT_USAGE("The class [%s] used in the @MetaDataScope is not registered as a @MetaDataCategory. Verify if the class [%s] is properly annotated."),
    METADATA_CONNECTOR_METADATA_ENABLED("The @Module should not implement the interface ConnectorMetaDataEnabled but rather make use of @MetaDataCategory."),
    METADATASWITCH_NO_LONGER_SUPPORTED("Using metaData attribute in @Connector/@Module is no longer supported. The connector will have Dynamic DataSense if has @MetaDataCategory in place, or static DataSense otherwise. Please remove the metaData attribute."),
    MULE_CONTEXT_AWARE_INTERFACE("Implementing MuleContextAware interface is discouraged. Instead, annotate the MuleContext field with @Inject, and provide the getter and setter for it."),
    MULTIMODULE_SAME_PROCESSOR_NAMES("Two or more classes annotated with @Module or @Connector not sharing the same module namespaces have a @Processor with the exact name: [%s]."),
    MULTIMODULE_CONNECTORS_HAVE_SAME_FRIENDLY_NAMES("If they belong to the same module, two or more @Module or @Connector classes cannot share the same friendly name."),
    ONE_TYPE_OF_MODULE_PER_NAMESPACE("Only one class per Namespace (module name) can be annotated with a @Connector of type [%s]."),
    EXPRESSIONLANGUAGE_NAME_ALREADY_IN_USE("The name [%s] for an @ExpressionLanguage has already been used. Classes annotated with @ExpressionLanguages can not repeat the same name with any other module kind (@Connector, @Module, or even @ExpressionLanguage)."),
    PROCESSOR_CANNOT_BE_STATIC("@Processor cannot be applied to a static method."),
    PROCESSOR_CANNOT_BE_GENERIC("@Processor cannot be applied to a generic method."),
    PROCESSOR_CANNOT_BE_INJECTED("[%s] cannot be annotated with @Inject. If the signature method has either MuleEvent or MuleMessage as parameter, DevKit will properly inject it when being called."),
    PROCESSOR_MUST_BE_PUBLIC("@Processor cannot be applied to a non-public method."),
    PROCESSOR_CANNOT_BE_ABSTRACT_UNLESS_RESTCALL("@Processor cannot be applied to an abstract method that is not annotated with @RestCall."),
    PAGED_PROCESSOR_INCORRECT_TYPE("Processor method [%s] is set as paged but its return type is [%s]. Only [%s] is accepted for paged processors."),
    TRANSFORMING_VALUE_ANNOTATION("The annotation @UserDefinedMetaData can only be used when returning a TransformingValue type of object."),
    PROCESSOR_PARAMETER_USES_RESERVED_IDENTIFIER("@Processor method cannot contain a parameter identified by [%s]. [%s] is a reserved identifier."),
    PROCESSOR_MULTIPLE_PARAMETERS_SAME_ANNOTATION("You cannot have more than one of InboundHeader, OutboundHeaders, InvocationHeaders, SessionHeaders, ExceptionPayload, CorrelationId, CorrelationSequence, CorrelationGroupSize, MessageUniqueId, MessageRootId, Expr or Payload annotation."),
    INCOMPATIBLE_ANNOTATIONS("You cannot use Default or Optional annotations with this annotation."),
    OPTIONAL_PARAMS_CANNOT_BE_PRIMITIVE("@Optional parameters can not be applied to primitive types without a @Default value. Add a @Default value or change the parameter type to a non-primitive kind."),
    DEFAULT_IMPLIES_OPTIONAL("When using @Default, the @Optional annotation is redundant (@Default implies @Optional). If possible, discard the @Optional in the parameter [%s]."),
    PROCESSOR_PARAMETERS_CANNOT_BE_ARRAYS("@Processor parameter cannot be arrays, use List instead."),
    DEFAULT_VALUE_INVALID_FOR_ENUM("@Default value is not valid for this enum, check the enum declaration."),
    LITERAL_SUPPORT("A @Literal parameter is supported only for @Processor, @Source and @Filter"),
    LITERAL_SUPPORTS_STRING_OR_LIST("@Literal annotation only supports parameters of type String or List<String>"),
    QUERY_ANNOTATION_ONE_PER_METHOD("You cannot have more than one @Query annotation in each method."),
    PAGED_PROCESSOR_TWO_ARGUMENTS_SAME_TYPE("Paged processor [%s] has two arguments of type [%s]. Only one is allowed for paged methods."),
    PAGES_PROCESSOR_MISSING_REQUIRED_ARGUMENT("Paged processor [%s] has to receive one argument of type [%s]."),
    PAGED_PROCESSOR_INTERCEPTING_INVALID_COMBO("Processor method [%s] is set as intercepting and paged at the same time. Such a combination is not valid."),
    INTERCEPTING_METHOD_MISSING_SOURCECALLBACK_PARAM("An intercepting method method must contain a SourceCallback as one of its parameters."),
    DSQLQUERY_TYPE_DISABLES_NATIVE_QUERY_USAGE("Having a @Query parameter of type DsqlQuery will disable native query usage."),
    QUERY_MUST_BE_STRING_OR_DSQLQUERY("The @Query should be applied either on String parameter or DsqlQuery parameter without translator declared."),
    PRIMARY_NODE_ONLY_ATTRIBUTE_ONLY_WORKS_WITH_MULE_33("The attribute primaryNodeOnly works with Mule 3.3 only therefore you must set the minMuleVersion of your @Connector or @Module to \"3.3\". Example: @Module(minMuleVersion=\"3.3\")."),
    MIN_MULE_VERSION_PARSE_ERROR("Error parsing Mule version, verify that the minMuleVersion is in the correct format: X.X.X ."),
    SOURCE_CANNOT_BE_STATIC("@Source cannot be applied to a static method."),
    SOURCE_CANNOT_BE_GENERIC("@Source cannot be applied to a generic method."),
    SOURCE_MUST_BE_PUBLIC("@Source cannot be applied to a non-public method."),
    SOURCE_PARAMETER_USES_RESERVED_IDENTIFIER("@Source method cannot contain a parameter identified by [%s]. [%s] is a reserved identifier."),
    SOURCE_METHOD_MISSING_SOURCECALLBACK_PARAM("@Source method must contain a SourceCallback as one of its parameters."),
    SOURCE_CANNOT_HAVE_MULE_EVENT_OR_MESSAGE_AS_PARAMETER("@Source methods do not support [%s] type as Parameter"),
    TRANSFORMER_MUST_BE_STATIC("@Transformer must be a static method."),
    TRANSFORMER_MUST_BE_PUBLIC("@Transformer cannot be applied to a non-public method."),
    TRANSFORMER_CANNOT_RETURN_VOID("@Transformer cannot return void."),
    TRANSFORMER_CANNOT_RETURN_OBJECT("@Transformer cannot return java.lang.Object."),
    TRANSFORMER_MUST_RECEIVE_ONE_ARGUMENT("@Transformer must receive exactly one argument."),
    TRANSFORMER_MUST_HAVE_SOURCE_TYPES("@Transformer must have at declare at least one element in the sourceTypes attribute."),
    TRANSFORMERRESOLVER_MUST_BE_STATIC("@TransformerResolver must be a static method"),
    TRANSFORMERRESOLVER_MUST_BE_PUBLIC("@TransformerResolver cannot be applied to a non-public method"),
    TRANSFORMERRESOLVER_MUST_RETURN_TRANSFORMER("@TransformerResolver must return org.mule.api.transformer.Transformer"),
    TRANSFORMERRESOLVER_MUST_RECEIVE_3_ARGUMENTS("@TransformerResolver must receive exactly 3 arguments."),
    TRANSFORMERRESOLVER_INCORRECT_PARAMETERS("@TransformerResolver must receive the following parameters: DataType, DataType and MuleContext."),
    SIZE_ANNOTATION_INCORRECT_ARGUMENT_TYPE("@Size annotation doesn't apply on argument type [%s]."),
    PATTERN_ANNOTATION_INCORRECT_ARGUMENT_TYPE("@Pattern annotation doesn't apply on argument type [%s]."),
    EXPRESSIONLANGUAGE_EXPRESSIONEVALUATOR_INCORRECT_COUNT("An @ExpressionLanguage can only contain one @ExpressionEvaluator."),
    EXPRESSIONLANGUAGE_EXPRESSIONENRICHER_INCORRECT_COUNT("An @ExpressionLanguage can only contain one @ExpressionEnricher."),
    EXPRESSIONLANGUAGE_REQUIRES_ENRICHER_OR_EVALUATOR_OR_BOTH("An @ExpressionLanguage must contain one @ExpressionEnricher or one @ExpressionEvaluator or both."),
    EXPRESSIONEVALUATOR_REQUIRES_STRING("An @ExpressionEvaluator must receive at least a String that represents the expression to evaluate."),
    EXPRESSIONEVALUATOR_CANNOT_RETURN_VOID("@ExpressionEvaluator cannot be void."),
    EXPRESSIONEVALUATOR_REQUIRES_ANNOTATIONS("An @ExpressionEvaluator can receive only one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders."),
    EXPRESSIONENRICHER_REQUIRES_STRING("An @ExpressionEnricher must receive at least a String that represents the expression and Object that represents the object to be used for enrichment."),
    EXPRESSIONENRICHER_MUST_RETURN_VOID("@ExpressionEnricher must be void."),
    EXPRESSIONENRICHER_WRONG_ARGUMENTS("An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders."),
    ERROR_VALIDATING_EXAMPLE("Error validating example: [%s] Failing example: [%s]."),
    OAUTHACCESSTOKENIDENTIFIER_MUST_RETURN_STRING("A @OAuthAccessTokenIdentifier must return java.lang.String."),
    OAUTHACCESSTOKENIDENTIFIER_MUST_BE_PUBLIC("A @OAuthAccessTokenIdentifier method must be public."),
    OAUTHACCESSTOKENIDENTIFIER_CANNOT_BE_STATIC("A @OAuthAccessTokenIdentifier cannot be static."),
    OAUTHACCESSTOKENIDENTIFIER_CANNOT_HAVE_ARGS("The @OAuthAccessTokenIdentifier method cannot receive any arguments."),
    OAUTHPOSTAUTHORIZATION_CANNOT_BE_PRIVATE("@OAuthPostAuthorization-annotated method must be public or protected."),
    OAUTHPOSTAUTHORIZATION_CANNOT_HAVE_PARAMETERS("@OAuthPostAuthorization-annotated method cannot have any parameter."),
    OAUTHPOSTAUTHORIZATION_CANNOT_BE_STATIC("@OAuthPostAuthorization-annotated method cannot be static."),
    OAUTHPOSTAUTHORIZATION_MUST_RETURN_VOID("@OAuthPostAuthorization-annotated method must be void."),
    OAUTH_REQUIRES_CONNECTOR("It is not possible to use OAuth support in @Module annotated classes, use @Connector instead."),
    OAUTH_REQUIRES_OAUTHCONSUMERKEY("@OAuth class must contain a field annotated with @OAuthConsumerKey."),
    OAUTHCONSUMERKEY_MISSING_GETTER("@OAuthConsumerKey-annotated field must have a public getter."),
    OAUTHCONSUMERKEY_MISSING_SETTER("@OAuthConsumerKey-annotated field must have a public setter."),
    OAUTH_REQUIRES_OAUTHCONSUMERSECRET("@OAuth class must contain a field annotated with @OAuthConsumerSecret."),
    OAUTHCONSUMERSECRET_REQUIRES_GETTER("@OAuthConsumerSecret-annotated field must have a public getter."),
    OAUTHCONSUMERSECRET_REQUIRES_SETTER("@OAuthConsumerSecret-annotated field must have a public setter."),
    OAUTHACCESSTOKEN_PARAMETER_NO_LONGER_SUPPORTED("The use of @OAuthAccessToken in parameters in @Processor methods is no longer supported as of DevKit 3.3.1. Instead please declare a field in the @Connector with the annotation instead."),
    OAUTH_REQUIRES_OAUTHACCESSTOKEN("@OAuth class must contain a field annotated with @OAuthAccessToken."),
    OAUTHACCESSTOKEN_MISSING_GETTER("@OAuthAccessToken-annotated field must have a public getter."),
    OAUTHACCESSTOKEN_MISSING_SETTER("@OAuthAccessToken-annotated field must have a public setter."),
    DEOAUTH_REQUIRES_OAUTHACCESSTOKENSECRETKIT_167("@OAuth class must contain a field annotated with @OAuthAccessTokenSecret."),
    OAUTHACCESSTOKENSECRET_MISSING_GETTER("@OAuthAccessTokenSecret-annotated field must have a public getter."),
    OAUTHACCESSTOKENSECRET_MISSING_SETTER("@OAuthAccessTokenSecret-annotated field must have a public setter."),
    AUTH_PARAMETER_TYPE_NOT_SUPPORTED("The type [%s] is not a supported authorization parameter type."),
    OAUTH1_DOES_NOT_SUPPORT_OAUTHACCESSTOKENIDENTIFIER("@OAuthAccessTokenIdentifier-annotated method is not supported with OAuth 1.0a."),
    OAUTHACCESSTOKENSECRET_PARAMETER_NO_LONGER_SUPPORTED("The use of @OAuthAccessTokenSecret in parameters in @Processor methods is no longer supported as of DevKit 3.3.1. Instead please declare a field in the @Connector with the annotation instead."),
    OAUTHCALLBACKPARAMETER_MISSING_SETTER("The field [%s] must have a setter to be annotated with @OAuthCallbackParameter."),
    RESTCALL_METHOD_MUST_BE_ABSTRACT("@RestCall can only be applied to abstract methods."),
    RESTCALL_MUST_THROW_IOEXCEPTION("@RestCall abstract method must throw IOException."),
    RESTEXCEPTIONON_MISSING_EXPRESSION("@RestExceptionOn requires a expression to be defined."),
    MULTIPLE_PARAMETERS_SET_AS_PAYLOAD("Only one parameter can be used as payload, everything else must be annotated with @RestUriParam, @RestPostParam, @RestQueryParam or @RestHeaderParam."),
    POST_METHOD_DOES_NOT_SUPPORT_UNANNOTATED_PARAMS_AND_PAYLOAD("Post method supports a non annotated parameter as payload or @RestPostParam parameters, not both."),
    RESTPOSTPARAM_CAN_ONLY_BE_USED_ON_POST_METHODS("@RestPostParam can only be used on POST methods."),
    BINARYPARAM_MORE_THAN_ONE("There are more than one @BinaryParam annotations, and only the payload can make use of it."),
    BINARYPARAM_PARAMETER_MUST_IMPLEMENT_INPUTSTREAM("@BinaryParam requires that the payload implements InputStream's interface."),
    BINARYPARAM_CAN_ONLY_BE_USED_ON_POST_METHODS("@BinaryParam can only be used on POST methods."),
    BINARYPARAM_ONLY_SUPPORTS_PAYLOAD("Only the payload can be annotated with @BinaryParam."),
    RESTURIPARAM_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked with @RestUriParam."),
    RESTQUERYPARAM_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked with @RestQueryParam."),
    RESTHEADERPARAM_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked with @RestHeaderParam."),
    RESTPOSTPARAM_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked with @RestPostParam."),
    RESTHTTPCLIENT_INCORRECT_TYPE("A field annotated with @RestHttpClient must be of type [%s]."),
    RESTHTTPCLIENT_MISSING_GETTER("Cannot find a getter method for [%s] but its being marked with @RestHttpClient."),
    DEVKIT_PACKAGE_PROPERTY_REQUIRES_AT_LEAST_ONE_MODULE("There must be at least one class annotated with @Connector or @Module in order to use the flag -Ddevkit.studio.package.skip=false ."),
    MISSING_ICON("The [%s] is missing the icon file for the Studio package generation, the expected file [%s] does not exist. The generic one is going to be taken."),
    INVALID_ICON_SIZE("The icon [%s] has an invalid size. Wanted size: [%sx%s], but was: [%sx%s]."),
    UNKNOWN_ERROR_VERIFYING_CONNECTOR_ICON("An unknown error happened opening the icon connector [%s]"),
    CLASS_MISSING_SUMMARY( "Class [%s] is not properly documented. A summary is missing."),
    CLASS_MISSING_AUTHOR_TAG("Class [%s] needs to have an @author tag."),
    FIELD_MISSING_DESCRIPTION("Field [%s] is not properly documented. The description is missing."),
    METHOD_PARAMETER_MISSING_JAVADOC("Parameter [%s] of method [%s] is not properly documented. A matching @param in the method documentation was not found."),
    METHOD_MISSING_DESCRIPTION("Method [%s] is not properly documented. A description of what it can do is missing."),
    METHOD_MISSING_RETURN_TYPE_DOCUMENTATION( "The return type of a non-void method must be documented. Method [%s] is at fault. Missing @return."),
    METHOD_MISSING_DOCUMENTATION_FOR_THROWN_EXCEPTIONS("Every exception declared in the 'throws' clause needs to be documented. Method [%s] Exception [%s]."),
    SAMPLE_PROCESSOR_XML_DOES_NOT_EXIST( "The {@sample.xml} pointed by [%s] in the method [%s] does not exists"),
    SAMPLE_FILE_CONTAINING_EXAMPLES_DOES_NOT_EXIST("The path [%s] of the {@sample.xml} in the method [%s] does not exists"),
    NAME_ATTRIBUTE_CANNOT_BE_EMPTY("The name attribute must not be empty."),
    NAME_ATTRIBUTE_INCORRECT_PATTERN("The name attribute [%s] must start with a letter, and might be followed: with a letter, number, _, or -. "),
    NAME_ATTRIBUTE_MUST_NOT_CONTAIN_WHITESPACE("The name attribute [%s] must not contain whitespaces."),
    FRIENDLYNAME_ATTRIBUTE_CANNOT_BE_EMPTY("The friendlyName attribute must not be empty."),
    INVALIDATECONNECTIONON_CANNOT_BE_USED_WITH_RECONNECTON("@InvalidateConnectionOn can not be used if the connector has @ReconnectOn. Replace @InvalidateConnectionOn for @ReconnectOn, or discard all @ReconnectOn from the module"),
    OAUTHINVALIDATEACCESSTOKENON_CANNOT_BE_USED_WITH_RECONNECTON("@OAuthInvalidateAccessTokenOn can not be used if the connector has @ReconnectOn. Replace @OAuthInvalidateAccessTokenOn for @ReconnectOn, or discard all @ReconnectOn from the module"),
    INVALIDATECONNECTIONON_IS_DEPRECATED("@InvalidateConnectionOn is deprecated and will be removed in DevKit 4.0, replace the annotation for @ReconnectOn."),
    INVALIDATEACCESSTOKENON_IS_DEPRECATED("@OAuthInvalidateAccessTokenOn is deprecated and will be removed in DevKit 4.0, replace the annotation for @ReconnectOn."),
    PROCESSORS_RECONNECT_ON_SAME_EXCEPTIONS("There are several @Processor methods annotated with the same exception for @InvalidateConnectionOn/@OAuthInvalidateAccessTokenOn ([%s]). All of them can be replaced with one @ReconnectOn, at class level."),
    PROCESSOR_NAME_ALREADY_IN_USE("The name of this annotated operation [%s] is already being used. Consider renaming the operation or the name attribute of the annotation."),
    PROVIDERAWAREPAGINGDELEGATE_INCORRECT_TYPE("Notice that on @Paged processors when returning " + ProviderAwarePagingDelegate.class.getSimpleName() + "<T,P> P type must be the type of your connector. Current one is [%s]"),
    PROVIDERAWAREPAGINGDELEGATE_MISSING_PAGED_ANNOTATION("The @Processor method returns a " + ProviderAwarePagingDelegate.class.getSimpleName() + " but it is not annotated with the @Paged annotation. The behaviour for this message processor might not be as expected since Mule will not be able to execute pagination queries automatically. To implement automatic paging, please add the @Paged annotation to the @Processor method."),
    NAME_ATTRIBUTE_CANNOT_BE_TEST("The name attribute must not be \"test\"."),
    PROCESSOR_MISSING_PAGED_ANNOTATION("The @Processor [%s] receives one argument of type [%s] but it's not annotated with @Paged. This type of object can only be used as long as the @Processor is also @Paged."),
    CONNECTIONKEY_PARAMETER_HAS_DEFAULT_VALUE("@ConnectionKey parameters can not be annotated with @Default."),
    CONNECTIONKEY_PARAMETER_HAS_DEFAULT_VALUE_WITH_OVERRIDE("@ConnectionKey parameters can not be annotated with @Default when the @ConnectionManagement uses @OverrideAtProcessors."),
    CONNECTOR_HAS_CONFIG_AND_CONNECT_ANNOTATIONS("The @Connector [%s] must choose between defining @Config or declare the connection in place with the @Connect annotation"),
    CON_MANAGEMENT_DUPLICATED_CONNECT_METHOD("@ConnectionManagement [%s] has duplicated @Connect method."),
    OAUTH2_AT_CONNECTOR_LEVEL_DEPRECATED("The usage of @OAuth2 at @Connector level is deprecated. Use @OAuth2 with proper @Config instead. Check the @Config documentation in https://www.mulesoft.org/documentation/display/36X/Connector+Migration+Guide+-+Mule+3.5+to+3.6"),
    CONNECTOR_CANNOT_BE_ANNOTATED_WITH_HTTP_BASIC_AUTH("The usage of @HttpBasicAuth at @Connector level is erroneous. Use @HttpBasicAuth with proper @Config instead."),
    CONNECTION_METHODS_AT_CONNECTOR_LEVEL_DEPRECATED("The usage of all connection methods :@Connect, @Disconnect, @ConnectionIdentifier and @ValidateConnection at @Connector level is deprecated. Use @ConnectionManagement with proper @Config instead. Check the @Config documentation in https://www.mulesoft.org/documentation/display/36X/Connector+Migration+Guide+-+Mule+3.5+to+3.6"),
    CONFIGURABLE_FIELDS_CRASHES("@Configurable field [%s] at [%s] clashes with @Configurable declared at [%s] @Connector"),
    CONNECTOR_CANNOT_BE_ANNOTATED_WITH_CONNECTION_MANAGEMENT("@Connector [%s] cannot be annotated with @ConnectionManagement. Authentication must be declared on another file"),
    PROCESSOR_IS_CALLED_NO_OPERATION_SELECTED("A [%s] cannot start with the literal [no-operation-selected], change the method name or the name attribute of the annotation."),
    LITERAL_CANNOT_BE_USED_AS_A_NAME("The literal [%s] can not be used as a [%s] name."),
    POLLINGPERIOD_ONLY_ALLOWED_FOR_POLLING_SOURCESTRATEGY("PollingPeriod in Message Source [%s] is only allowed for SourceStrategy.POLLING"),
    POLLINGPERIOD_PARAMETER_RESERVED("Parameter name pollingPeriod in Message Source [%s] is reserved for SourceStrategy.POLLING"),
    POLLINGPERIOD_REQUIRES_DEFAULT_VALUE("PollingPeriod in Message Source [%s] has to have a default value when using SourceStrategy.POLLING"),
    PARAMS_NOT_SUPPORTED("Parameters of type %s are not supported. Invalid parameter: [%s]"),
    FIELD_CANNOT_BE_EMPTY("Field [%s] cannot be empty."),
    INVALID_REGEX("The regex defined on field [%s] is not valid. The regex %s is not valid."),
    INVALID_CATEGORY("The <category> property defined in pom.xml is set to [%s]. Valid options are %s."),
    COMMUNITY_CATEGORY_REQUIRES_LICENSE("The <category> property defined in pom.xml is set to Community. This <category> requires the connector to run on CE runtimes. %s, or change the connectors <category>"),
    NON_COMMUNITY_CATEGORY_REQUIRES_LICENSE("The <category> property defined in pom.xml is set to %s. This <category> requires the connector to run on EE runtimes only. Add the annotation %s, or change the connectors <category> to %s"),
    INVALID_REQUIRED_LIBS_DEFINITION("Invalid required libraries definition found in file [%s], [%s]"),
    CONFIGURABLE_FORBIDDEN_NAME("A @Configurable field can not repeat the name of any parameter that belongs to the @Connect method"),
    OAUTH2_COMPONENT_CANNOT_BE_CONNECTOR("An @OAuth2 cannot be annotated with @Connector"),
    OAUTH2_COMPONENT_CANNOT_BE_MODULE("An OAuth2 cannot be annotated with @Module"),
    CON_MANAGEMENT_CANNOT_BE_OAUTH2("A @Config cannot be annotated both with @ConnectionManagement and @OAuth2"),
    CONFIG_OR_CONNECTION_STRATEGY("@ConnectionStrategy and @Config cannot be used in the same connector."),
    CONNECTION_STRATEGY_DEPRECATED("@ConnectionStrategy is deprecated and @Config should be used."),
    MORE_THAN_ONE_CONFIG_STRATEGY_NOT_ALLOWED("More than one [%s] are not allowed"),
    CONFIG_STRATEGY_MISSING_GETTER("Getter method not found [%s] field [%s]"),
    CONFIG_STRATEGY_MISSING_SETTER("Setter method not found for [%s] field [%s]"),
    CONFIG_NAMES_MUST_BE_UNIQUE("The configElementName attribute value [%s] is also repeated on [%s] @Config components. @Config configElementName values must be unique along all defined strategies (default value is 'config')."),
    CONSUMER_SECRET_MUST_BE_CONFIGURABLE("@OAuthConsumerSecret must be a @Configurable"),
    CONSUMER_KEY_MUST_BE_CONFIGURABLE("@OAuthConsumerKey must be a @Configurable"),
    HTTP_BASIC_AUTH_WITHOUT_RESTCALL("As the connector [%s] does not have any @Processor annotated with @RestCall, it does not have sense to have a strategy with @HttpBasicAuth."),
    HTTP_BASIC_AUTH_REPEATED_ANNOTATION("A @HttpBasicAuth component can not have more than 1 [%s]."),
    HTTP_BASIC_AUTH_REQUIRES_STRING("[%s] annotation type's must be String."),
    MODULES_SAME_NAMESPACE("@Connector/@Module namespace must be unique."),
    RETURN_TYPE_FOR_EXCEPTION_HANDLE("Return type for @Handle method must be void instead of [%s]."),
    PARAMETERS_COUNT_FOR_EXCEPTION_HANDLE("@Handle method should have a single parameter of type Exception, [%s] parameters found."),
    EXCEPTION_HANDLE_PARAMETER_EXCEPTION_ONLY("@Handle method should receive an Exception as parameter, type [%s] found."),
    EXCEPTION_HANDLE_NO_THROWS_DECLARED("@Handle method must throw Exception."),
    METHOD_VISIBILITY_ON_EXCEPTION_HANDLE("@Handle method must be non-static and public."),
    INVALID_HANDLES_COUNT_FOR_EXCEPTION_HANDLER("One method must be annotated with @Handle, found [%s] in handler."),
    DECLARED_HANDLER_NOT_ANNOTATED("Declared handler for @OnException is not a @Handler."),
    METHOD_TYPE_NOT_SUPPORTED_FOR_ON_EXCEPTION("@OnException handling can only be applied to a @Processor method"),
    MISSING_SETTER("field [%s] should have public setter"),
    MISSING_GETTER("field [%s] should have public getter"),
    CONFIGURABLE_FOR_PURE_TRANSFORMER("[%s] cannot have @Configurable fields. They will not be accessible from it."),
    OVERRIDE_AT_PROCESSORS_ONLY_ONCE("Only one @ConnectionManagement can be annotated with @OverrideAtProcessor"),
    CONNECT_METHODS_ONLY_IN_CONNECTION_MANAGEMENT("@Connect, @ConnectionIdentifier, @Disconnect and @ValidateConnection can only be used in a @ConnectionManagement strategy"),
    TEXT_SUPPORTS_STRING("@Text annotation only supports parameters of type String"),
    TEXT_SUPPORT("A @Text parameter is supported only for @Processor"),
    MISSING_METHOD_ANNOTATED_WITH_IN_WSDL_PROVIDER("Missing method annotated with [%s] in WsdlProvider strategy"),
    TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER("Too many methods annotated with [%s] found in WsdlProvider strategy, expected [%s] but found [%s]"),
    NO_PROCESSORS_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER("Processors are not allowed in class [%s] since it's using a WsdlProvider strategy"),
    NO_CONFIGURABLES_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER("@Configurable are not allowed in class [%s] since it's using a WsdlProvider strategy"),
    MIN_MULE_VERSION_FEATURE_SUPPORT("The minMuleVersion attribute should be [%s] or higher when using [%s], but [%s] was found."),
    MULTIPLE_CONFIGS_DECLARED_IN_CONNECTOR_CLASS("Only one @Config can be declared in class [%s]"),
    INVALID_PARAMETERS_FOR_METHOD_ONLY_ONE_ALLOWED("Method annotated with [%s] should have one and only one parameter of type [%s]"),
    INVALID_PARAMETERS_FOR_METHOD_ONLY_THIS_ALLOWED("Method annotated with [%s] should have the following parameter types [%s]"),
    INVALID_KEY_SEPARATOR_IS_BLANK("Invalid keySeparator found in [%s], separator cannot be blank"),
    INVALID_KEY_SEPARATOR_INCONSISTENT("Different keySeparator definitions found across WsdlProviders: [%s], all definitions must be the same"),
    INVALID_KEY_SEPARATOR("Invalid keySeparator [%s] found in [%s]: [%s]"),
    INVALID_KEY_LABEL_IS_BLANK("Invalid key label found in [%s], label cannot be blank"),
    INVALID_KEY_LABELS_INCONSISTENT("Different keyLabels definitions found across WsdlProviders: [%s], all definitions must be the same"),
    INVALID_NUMBER_OF_KEY_LABELS("Invalid key labels [%s]"),
    INVALID_KEY_LABEL("Invalid key label [%s] found in [%s]: [%s]"),
    SERVICE_DEFINITION_MULTIPLE_RETURN_TYPES("Invalid WsdlServiceRetriever declaration, all the WSDLProviders must declare the same WsdlServiceRetriever signature"),
    NO_CONFIGURABLE_ALLOWED("@Configurable fields are not allowed in a @Connector/@Module class, move [%s] to a proper @Config instead"),
    BOOLEAN_CONFIGURABLE_MUST_HAVE_DEFAULT_AVALUE("Boolean @Configurable fields must define a @Default value"),
    NAME_CONFIGURABLE_MUST_HAVE_DEFAULT_AVALUE("A @Configurable with name 'name' can only be of String type."),
    MISSING_ENTITLEMENT_NAME("Invalid name for the Required Entitlement. Name cannot be blank"),
    WRONG_ENTITLEMENT_NAME("Invalid name for the Required Entitlement. Entitlement name cannot contain white spaces. CamelCase is recommended for this name"),
    MISSING_ENTITLEMENT_PROVIDER("Invalid provider name in RequiresEntitlement. Provider name cannot be blank"),
    WRONG_ENTITLEMENT_PROVIDER("Invalid provider name in RequiresEntitlement. Provider name cannot contain white spaces. CamelCase is recommended for this name"),
    MISSING_ENTITLEMENT_KEY("Missing signing key [%s] for the Required Entitlement [%s]. The key must be placed under 'src/main/resources' or 'src/main/resources/license'"),
    DEFAULT_CONFIG_ELEMENT_NAME_CHANGED("The configElementName attribute is deprecated in @Connector/@Module, create a @Config with a custom configElementName instead"),
    USE_CONNECTOR_INSTEAD("Usage of @Module is discouraged since it’s deprecated. Use @Connector instead to declare your Connector. http://mulesoft.github.io/mule-devkit/3.7.1/apidocs/index.html"),
    MISSING_ON_EXCEPTION_STRATEGY("No exception @Handler was declared for the connector. %s"),
    INVALID_STRATEGY_FOR_MODULE("Only @Configuration kind of strategies are allowed for modules. Invalid strategy %s was found");

    private final String message;

    Message(String message){
        this.message = formatMessage(message);
    }

    @Override
    public String getCode() {
        return this.toString();
    }

    @Override
    public String getMessage() {
        return message;
    }

    private String formatMessage(String message){
        if (StringUtils.isEmpty(message) ){
            return message;
        }
        String formattedMessage = StringUtils.trim(message);
        formattedMessage = StringUtils.capitalize(formattedMessage);
        //adding a last dot if not existed
        formattedMessage+= (formattedMessage.substring(formattedMessage.length() - 1).equals("."))?"":".";
        return formattedMessage;
    }
}
