/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.api.gatherer.printing;

import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Pair;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.gatherer.Notification;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.api.gatherer.printing.FileNotificationMessage;
import org.mule.devkit.generation.api.gatherer.printing.PrinterGatherer;

public class GathererPrinterHelper
implements PrinterGatherer {
    @Override
    public void printErrors(NotificationGatherer notificationGatherer, ProcessingEnvironment processingEnv, Context context) {
        this.printKind(notificationGatherer.getErrors(), processingEnv, context, Diagnostic.Kind.ERROR, "error", "errors");
    }

    @Override
    public void printWarnings(NotificationGatherer notificationGatherer, ProcessingEnvironment processingEnv, Context context) {
        this.printKind(notificationGatherer.getWarnings(), processingEnv, context, Diagnostic.Kind.WARNING, "warning", "warnings");
    }

    @Override
    public void printNotes(NotificationGatherer notificationGatherer, ProcessingEnvironment processingEnv, Context context) {
        this.printKind(notificationGatherer.getNotes(), processingEnv, context, Diagnostic.Kind.NOTE, "note", "notes");
    }

    public void printKind(List<Notification> notificationsNotes, ProcessingEnvironment processingEnv, Context context, Diagnostic.Kind kind, String singular, String plural) {
        if (!notificationsNotes.isEmpty()) {
            try {
                StringBuilder builder = this.getCompleteNotificationLog(notificationsNotes, processingEnv, singular, plural);
                context.getMessager().printMessage(kind, builder.toString());
            }
            catch (Exception e) {
                for (Notification notification : notificationsNotes) {
                    Element element = notification.getDetails().getElement().unwrap();
                    context.getMessager().printMessage(kind, notification.getDetails().getMessage(), element);
                }
            }
        }
    }

    private StringBuilder getCompleteNotificationLog(List<Notification> notifications, ProcessingEnvironment processingEnv, String singular, String plural) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        String tab = "  ";
        Integer index = 1;
        StringBuilder builder = new StringBuilder();
        Map<String, List<FileNotificationMessage>> fileNotificationsMap = this.parseAndSortNotifications(notifications, processingEnv);
        String specificMessage = notifications.size() > 1 ? "(" + notifications.size() + ") " + plural + " where" : singular + " was";
        builder.append("***************************************************").append(lineSeparator).append("The following " + specificMessage + " encountered while compiling:").append(lineSeparator);
        for (Map.Entry<String, List<FileNotificationMessage>> entry : fileNotificationsMap.entrySet()) {
            builder.append(lineSeparator).append("File: ").append(entry.getKey());
            for (FileNotificationMessage fnm : entry.getValue()) {
                builder.append(lineSeparator).append(tab + index + ") " + fnm.getMessage() + ":" + fnm.getLine());
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            builder.append(lineSeparator);
        }
        return builder;
    }

    private Map<String, List<FileNotificationMessage>> parseAndSortNotifications(List<Notification> notifications, ProcessingEnvironment processingEnv) throws IOException {
        HashMap<String, List<FileNotificationMessage>> messageMap = new HashMap<String, List<FileNotificationMessage>>();
        ArrayList<FileNotificationMessage> fileNotificationMessageList = new ArrayList<FileNotificationMessage>();
        for (Notification notification : notifications) {
            JavacElements elemUtils = (JavacElements)processingEnv.getElementUtils();
            Pair<JCTree, JCTree.JCCompilationUnit> treeTop = elemUtils.getTreeAndTopLevel(notification.getDetails().getElement().unwrap(), null, null);
            String file = ((JCTree.JCCompilationUnit)treeTop.snd).getSourceFile().toUri().getPath();
            FileReader fr = new FileReader(file);
            LineNumberReader lineNumberReader = new LineNumberReader(fr);
            lineNumberReader.skip(((JCTree)treeTop.fst).getPreferredPosition());
            int line = lineNumberReader.getLineNumber() + 1;
            fileNotificationMessageList.add(new FileNotificationMessage(file, line, notification.getDetails().getMessage()));
            if (!messageMap.containsKey(file)) {
                messageMap.put(file, new ArrayList());
            }
            ((List)messageMap.get(file)).add(new FileNotificationMessage(file, line, notification.getDetails().getMessage()));
        }
        for (Map.Entry entry : messageMap.entrySet()) {
            Collections.sort((List)entry.getValue());
        }
        return messageMap;
    }
}

