/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.api;

import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.module.Module;

import java.util.List;

/**
 * Verifies annotations are correctly used globally.
 */
public interface MultiModuleAnnotationVerifier extends Verifier {

    /**
     * Should this verifier be executed for the given modules?
     *
     * @param modules The modules to test
     * @return true if it should be verified, false otherwise
     */
    boolean shouldVerify(List<Module> modules);

    /**
     * @param modules The modules discriminate their kinds
     * @return A list of processable modules, discriminating which will be useful for the verification
     */
    List<Module> processableModules(List<Module> modules);


    /**
     * Verify the annotations on these modules
     *
     * @param modules The modules to be verified
     * @throws AnnotationVerificationException
     *          if the verification fails
     */
    void verify(List<Module> modules,NotificationGatherer gatherer) throws AnnotationVerificationException;
}
