package org.mule.devkit.generation.api;

/**
 * An enum that stores a list of valid categories that a connector can be assigned to.
 * A category is set by default when creating a new connector, however users can
 * configure this inside the pom.xml file as follows:
 * 
 * <properties>
 * 		...
 * 		<category>Community</category>
 * 		...
 * </properties>
 */
public enum ConnectorCategory {
		
	COMMUNITY("Community"),
	STANDARD("Standard"),
	SELECT("Select"),
	PREMIUM("Premium");
	
	private ConnectorCategory(String literal) {
		this.category = literal;
	}

	private String category;
	
	public String getCategory() {
		return category;
	}
	
	public static String[] getValidCategories() {
		return new String[] {
			COMMUNITY.getCategory(),
			STANDARD.getCategory(),
			SELECT.getCategory(),
			PREMIUM.getCategory()
		};
	}

}
