package org.mule.devkit.generation.api.gatherer;

import org.mule.devkit.model.Identifiable;

import java.util.*;

/**
 * Factory class to create a Simple NotificationGatherer
 */
public class DefaultGathererFactory implements NotificationGathererFactory {

    @Override
    public org.mule.devkit.generation.api.gatherer.NotificationGatherer create(){
        return new NotificationGatherer();
    }

    /**
     * Default class used to collect notifications.
     */
    private static class NotificationGatherer implements org.mule.devkit.generation.api.gatherer.NotificationGatherer {

        NotificationGatherer(){
            notifications = new HashSet<Notification>();
        }
        Set<Notification> notifications;

        @Override
        public boolean hasNotifications() {
            return notifications!=null && !notifications.isEmpty();
        }

        @Override
        public List<Notification> getErrors() {
            return filterNotificationsWithLvl(NotificationLevel.ERROR);
        }

        @Override
        public List<Notification> getWarnings() {
            return filterNotificationsWithLvl(NotificationLevel.WARNING);
        }

        @Override
        public List<Notification> getNotes() {
            return filterNotificationsWithLvl(NotificationLevel.NOTE);
        }

        @Override
        public boolean hasErrors() {
            return hasNotificationsWithLvl(NotificationLevel.ERROR);
        }

        @Override
        public boolean hasWarnings() {
            return hasNotificationsWithLvl(NotificationLevel.WARNING);
        }

        @Override
        public boolean hasNotes() {
            return hasNotificationsWithLvl(NotificationLevel.NOTE);
        }

        @Override
        public void error(Identifiable element, DevkitNotification error, Object... args) {
            notifications.add(new Notification(new  Details(String.format(error.getMessage(),args),element),NotificationLevel.ERROR));
        }

        @Override
        public void warn(Identifiable element, DevkitNotification error, Object... args) {
            notifications.add(new Notification(new  Details(String.format(error.getMessage(),args),element),NotificationLevel.WARNING));
        }

        @Override
        public void note(Identifiable element, DevkitNotification error, Object... args) {
            notifications.add(new Notification(new  Details(String.format(error.getMessage(),args),element),NotificationLevel.NOTE));
        }

        @Override
        public void errorAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            for (Identifiable e : elements) {
                error(e, error, args);
            }
        }

        @Override
        public void warnAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            for (Identifiable e : elements) {
                warn(e, error, args);
            }
        }

        @Override
        public void noteAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            for (Identifiable e : elements) {
                note(e, error, args);
            }
        }

        @Override
        public List<Notification> getNotifications() {
            return new ArrayList<Notification>(notifications);
        }

        private List<Notification> filterNotificationsWithLvl(NotificationLevel level) {
            List<Notification> filteredList = new ArrayList<Notification>();
            for(Notification notification : notifications){
                if(notification.getLevel().equals(level)){
                    filteredList.add(notification);
                }
            }
            return filteredList;
        }

        private boolean hasNotificationsWithLvl(NotificationLevel level) {
            for(Notification notification : notifications){
                if(notification.getLevel().equals(level)){
                    return true;
                }
            }
            return false;
        }
    }
}
