package org.mule.devkit.generation.api;

import java.util.List;

import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier.DummyGatherer;
import org.mule.devkit.generation.api.gatherer.Details;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Notification;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;


public abstract class AbstractBaseProjectVerifier implements ProjectVerifier {

	private Context context;
	
	public Context ctx() {
		return context;
	}
	
	public void setCxt(Context context) {
		this.context = context;
	}

    private NotificationGatherer gatherer;

    public NotificationGatherer getGatherer() {
        if( gatherer == null )
            return new DummyGatherer();
        return gatherer;
    }

    public void setGatherer(NotificationGatherer gatherer) {
        this.gatherer = gatherer;
    }
    
    class DummyGatherer implements  NotificationGatherer{

        private void logWarning(){
            System.out.println("Gatherer not set");
        }
        @Override
        public void error(Identifiable element, Details details) {
            logWarning();
        }

        @Override
        public void warn(Identifiable element, Details details) {
            logWarning();
        }

        @Override
        public void note(Identifiable element, Details details) {
            logWarning();
        }

        @Override
        public List<Notification> getNotifications() {
            logWarning();
            return null;
        }

        @Override
        public boolean hasNotifications() {
            logWarning();
            return false;
        }

        @Override
        public List<Notification> getErrors() {
            logWarning();
            return null;
        }

        @Override
        public List<Notification> getWarnings() {
            logWarning();
            return null;
        }

        @Override
        public List<Notification> getNotes() {
            return null;
        }

        @Override
        public boolean hasErrors() {
            logWarning();
            return false;
        }

        @Override
        public boolean hasWarnings() {
            logWarning();
            return false;
        }

        @Override
        public boolean hasNotes() {
            logWarning();
            return false;
        }

        @Override
        public void error(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void warn(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void note(Identifiable element, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void errorAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void warnAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }

        @Override
        public void noteAll(List<? extends Identifiable> elements, DevkitNotification error, Object... args) {
            logWarning();
        }
    }

}
