/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.api;

import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.module.Module;

/**
 * Verifies that annotations are consistent, sound and correctly used
 * within a module.
 */
public interface ModuleAnnotationVerifier extends Verifier {

    /**
     * Should this verifier be executed for the given module?
     *
     * @param module The module to test
     * @return true if it should be verified, false otherwise
     */
    boolean shouldVerify(Module module);

    /**
     * Verify the annotations on this module
     *
     * @param module The module to be verified
     * @throws AnnotationVerificationException
     *          if the verification fails
     */
    void verify(Module module,NotificationGatherer gatherer) throws AnnotationVerificationException;
}