/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.discovery;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.mule.devkit.dynamic.discovery.wagon.ManualWagonProvider;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenRepositoryDiscoverer {
    private static final Logger LOGGER = Logger.getLogger(MavenRepositoryDiscoverer.class.getPackage().getName());
    private final File localRepository;
    private static final File DEFAULT_LOCAL_REPOSITORY = new File(System.getProperty("user.home") + "/.m2/repository");
    private final List<RemoteRepository> repositories;
    private static final String DEFAULT_GROUP_ID = "org.mule.modules";
    private static final String DEFAULT_EXTENSION = "jar";
    private static final String DEFAULT_SCOPE = "compile";

    public MavenRepositoryDiscoverer() {
        this(DEFAULT_LOCAL_REPOSITORY);
    }

    public MavenRepositoryDiscoverer(File localRepository) {
        this(localRepository, Collections.emptyList());
    }

    public MavenRepositoryDiscoverer(File localRepository, List<RemoteRepository> repositories) {
        this.localRepository = localRepository;
        this.repositories = repositories;
    }

    public static List<RemoteRepository> defaultMuleForgeRepositories() {
        LinkedList<RemoteRepository> repositories = new LinkedList<RemoteRepository>();
        repositories.add(new RemoteRepository("central", "default", "http://repo1.maven.org/maven2/"));
        repositories.add(new RemoteRepository("muleforge", "default", "http://repository.mulesoft.org/releases/"));
        repositories.add(new RemoteRepository("muleforge-snapshots", "default", "http://repository.mulesoft.org/snapshots/"));
        repositories.add(new RemoteRepository("jboss", "default", "http://repository.jboss.org/nexus/content/repositories/"));
        return repositories;
    }

    public final List<URL> listDependencies(String artifactId, String version) throws DependencyCollectionException, DependencyResolutionException, MalformedURLException {
        return this.listDependencies(DEFAULT_GROUP_ID, artifactId, version);
    }

    public final List<URL> listDependencies(String groupId, String artifactId, String version) throws DependencyCollectionException, DependencyResolutionException, MalformedURLException {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        RepositorySystem system = (RepositorySystem)locator.getService(RepositorySystem.class);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact(groupId, artifactId, DEFAULT_EXTENSION, version), DEFAULT_SCOPE);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        for (RemoteRepository remoteRepository : this.repositories) {
            collectRequest.addRepository(remoteRepository);
        }
        DependencyNode node = system.collectDependencies((RepositorySystemSession)session, collectRequest).getRoot();
        system.resolveDependencies((RepositorySystemSession)session, new DependencyRequest(node, null));
        PreorderNodeListGenerator nodeListGenerator = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nodeListGenerator);
        LinkedList<URL> urls = new LinkedList<URL>();
        for (Artifact artifact : nodeListGenerator.getArtifacts(true)) {
            if (artifact.getFile() == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Failed to resolve artifact <{0}>; it will be ignored", artifact.getArtifactId());
                continue;
            }
            urls.add(artifact.getFile().toURI().toURL());
        }
        return urls;
    }
}

