
package org.mule.devkit.dynamic.api.helper;

import org.mule.devkit.dynamic.api.model.Module.Parameter;

import java.util.List;

/**
 * Helper methods for {@link Parameter}.
 */
public final class Parameters {

    /**
     * @param name
     * @return {@link Parameter} with specified name, null if none can be found
     */
    public static Parameter getParameter(final List<Parameter> parameters, final String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }

        for (final Parameter parameter : parameters) {
            if (name.equals(parameter.getName())) {
                return parameter;
            }
        }
        return null;
    }

}