/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.loader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.callback.SourceCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.Transformer;
import org.mule.devkit.dynamic.api.helper.Capabilities;
import org.mule.devkit.dynamic.api.helper.Classes;
import org.mule.devkit.dynamic.api.helper.ConnectionManager;
import org.mule.devkit.dynamic.api.helper.Reflections;
import org.mule.devkit.dynamic.api.model.Module;
import org.mule.util.StringUtils;

public class Loader {
    private static final String MESSAGE_PROCESSOR_CLASS_SUFFIX = "MessageProcessor";
    private static final String MESSAGE_SOURCE_CLASS_SUFFIX = "MessageSource";
    private static final String TRANSFORMER_CLASS_SUFFIX = "Transformer";
    private static final String PARAMETER_TYPE_FIELD_PREFIX = "_";
    private static final String PARAMETER_TYPE_FIELD_SUFFIX = "Type";

    protected final Class<?> findMessageProcessorClass(Package modulePackage, String processorName, ClassLoader classLoader) {
        String messageProcessorClassName = modulePackage.getName() + "." + StringUtils.capitalize((String)processorName) + MESSAGE_PROCESSOR_CLASS_SUFFIX;
        System.out.println(messageProcessorClassName);
        return Classes.loadClass(classLoader, messageProcessorClassName);
    }

    protected final Class<?> findMessageSourceClass(Package modulePackage, String sourceName, ClassLoader classLoader) {
        String messageSourceName = modulePackage.getName() + "." + StringUtils.capitalize((String)sourceName) + MESSAGE_SOURCE_CLASS_SUFFIX;
        return Classes.loadClass(classLoader, messageSourceName);
    }

    protected final Class<?> findTransformerClass(Package modulePackage, String transformerName, ClassLoader classLoader) {
        String transformerClassName = modulePackage.getName() + "." + StringUtils.capitalize((String)transformerName) + TRANSFORMER_CLASS_SUFFIX;
        return Classes.loadClass(classLoader, transformerClassName);
    }

    protected final Object extractAnnotation(Class<?> moduleClass) {
        Module moduleAnnotation = Classes.getDeclaredAnnotation(moduleClass, Module.class);
        if (moduleAnnotation != null) {
            return moduleAnnotation;
        }
        return Classes.getDeclaredAnnotation(moduleClass, Connector.class);
    }

    public final org.mule.devkit.dynamic.api.model.Module load(Capabilities module, ConnectionManager<?, ?> connectionManager) {
        return this.load(module, connectionManager, module.getClass().getPackage(), module.getClass().getClassLoader());
    }

    public final org.mule.devkit.dynamic.api.model.Module load(Capabilities module, ConnectionManager<?, ?> connectionManager, Package modulePackage, ClassLoader classLoader) {
        if (module == null) {
            throw new IllegalArgumentException("null module");
        }
        Class<?> moduleClass = module.getClass();
        Object annotation = this.extractAnnotation(moduleClass);
        if (annotation == null) {
            throw new IllegalArgumentException("Failed to find a Module annotation on <" + moduleClass.getCanonicalName() + ">");
        }
        String name = this.extractAnnotationName(annotation);
        String minMuleVersion = this.extractMinMuleVersion(annotation);
        List<Module.Parameter> parameters = this.listParameters(moduleClass);
        List<Module.Processor> processors = this.listProcessors(modulePackage, moduleClass, classLoader);
        List<Module.Source> sources = this.listSources(modulePackage, moduleClass, classLoader);
        List<Module.Transformer> transformers = this.listTransformers(modulePackage, moduleClass, classLoader);
        return new org.mule.devkit.dynamic.api.model.Module(name, minMuleVersion, module, parameters, processors, sources, transformers, connectionManager, classLoader);
    }

    protected final String extractClassName(String name) {
        String strippedClassName = name.substring(0, name.lastIndexOf("."));
        return strippedClassName.replace('/', '.');
    }

    protected final String extractAnnotationName(Object annotation) {
        return (String)Reflections.invoke(annotation, "name");
    }

    protected final String extractMinMuleVersion(Object annotation) {
        return (String)Reflections.invoke(annotation, "minMuleVersion");
    }

    protected final List<Module.Parameter> listParameters(Class<?> moduleClass) {
        LinkedList<Module.Parameter> parameters = new LinkedList<Module.Parameter>();
        for (Field field : Classes.allDeclaredFields(moduleClass)) {
            if (field.getAnnotation(Configurable.class) == null) continue;
            boolean optional = field.getAnnotation(Optional.class) != null;
            String defaultValue = field.getAnnotation(Default.class) != null ? field.getAnnotation(Default.class).value() : null;
            parameters.add(new Module.Parameter(field.getName(), field.getType(), optional, defaultValue));
        }
        return parameters;
    }

    protected final String extractName(Object annotation, Method method) {
        String annotationName = this.extractAnnotationName(annotation);
        if (!"".equals(annotationName)) {
            return annotationName;
        }
        return Classes.methodNameToDashBased(method);
    }

    protected final String[] extractMethodParameterNames(Class<?> generatedClass) {
        LinkedList<String> parameterNames = new LinkedList<String>();
        for (Field field : generatedClass.getDeclaredFields()) {
            String fieldName = field.getName();
            if (!fieldName.startsWith(PARAMETER_TYPE_FIELD_PREFIX) || !fieldName.endsWith(PARAMETER_TYPE_FIELD_SUFFIX)) continue;
            String parameterName = StringUtils.uncapitalize((String)fieldName.substring(PARAMETER_TYPE_FIELD_PREFIX.length(), fieldName.length() - PARAMETER_TYPE_FIELD_SUFFIX.length()));
            parameterNames.add(parameterName);
        }
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    protected final Class<?>[] extractMethodParameterTypes(Method method) {
        LinkedList parameterTypes = new LinkedList();
        for (Class<?> type : method.getParameterTypes()) {
            if (SourceCallback.class.equals(type)) continue;
            parameterTypes.add(type);
        }
        return parameterTypes.toArray(new Class[parameterTypes.size()]);
    }

    protected final List<Module.Parameter> listMethodParameters(Class<?> moduleClass, Method method, Class<?> generatedClass) {
        LinkedList<Module.Parameter> parameters = new LinkedList<Module.Parameter>();
        String[] parameterNames = this.extractMethodParameterNames(generatedClass);
        Class<?>[] parameterTypes = this.extractMethodParameterTypes(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String name = parameterNames[i];
            Class<?> type = parameterTypes[i];
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[i]);
            boolean optional = false;
            String defaultValue = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Optional) {
                    optional = true;
                }
                if (!(annotation instanceof Default)) continue;
                defaultValue = ((Default)Default.class.cast(annotation)).value();
            }
            parameters.add(new Module.Parameter(name, type, optional, defaultValue));
        }
        return parameters;
    }

    protected final List<Module.Processor> listProcessors(Package modulePackage, Class<?> moduleClass, ClassLoader classLoader) {
        LinkedList<Module.Processor> processors = new LinkedList<Module.Processor>();
        for (Method method : moduleClass.getMethods()) {
            Processor annotation = method.getAnnotation(Processor.class);
            if (annotation == null) continue;
            Class<?> messageProcessorClass = this.findMessageProcessorClass(modulePackage, method.getName(), classLoader);
            if (messageProcessorClass == null) {
                throw new IllegalArgumentException("Failed to find MessageProcessor class for processor <" + method.getName() + ">");
            }
            MessageProcessor messageProcessor = (MessageProcessor)Classes.newInstance(messageProcessorClass);
            if (messageProcessor == null) {
                throw new IllegalArgumentException("Failed to instantiate MessageProcessor class <" + messageProcessorClass.getCanonicalName() + ">");
            }
            processors.add(new Module.Processor(this.extractName(annotation, method), messageProcessor, this.listMethodParameters(moduleClass, method, messageProcessorClass), annotation.intercepting()));
        }
        return processors;
    }

    protected final List<Module.Source> listSources(Package modulePackage, Class<?> moduleClass, ClassLoader classLoader) {
        LinkedList<Module.Source> sources = new LinkedList<Module.Source>();
        for (Method method : moduleClass.getMethods()) {
            Source annotation = method.getAnnotation(Source.class);
            if (annotation == null) continue;
            Class<?> messageSourceClass = this.findMessageSourceClass(modulePackage, method.getName(), classLoader);
            if (messageSourceClass == null) {
                throw new IllegalArgumentException("Failed to find MessageSource class for processor <" + method.getName() + ">");
            }
            MessageSource messageSource = (MessageSource)Classes.newInstance(messageSourceClass);
            if (messageSource == null) {
                throw new IllegalArgumentException("Failed to instantiate MessageSource class <" + messageSourceClass.getCanonicalName() + ">");
            }
            sources.add(new Module.Source(this.extractName(annotation, method), messageSource, this.listMethodParameters(moduleClass, method, messageSourceClass)));
        }
        return sources;
    }

    protected final List<Module.Transformer> listTransformers(Package modulePackage, Class<?> moduleClass, ClassLoader classLoader) {
        LinkedList<Module.Transformer> transformers = new LinkedList<Module.Transformer>();
        for (Method method : moduleClass.getMethods()) {
            org.mule.api.annotations.Transformer annotation = method.getAnnotation(org.mule.api.annotations.Transformer.class);
            if (annotation == null) continue;
            Class<?> transformerClass = this.findTransformerClass(modulePackage, method.getName(), classLoader);
            if (transformerClass == null) {
                throw new IllegalArgumentException("Failed to find Transformer class for processor <" + method.getName() + ">");
            }
            Transformer transformer = (Transformer)Classes.newInstance(transformerClass);
            if (transformer == null) {
                throw new IllegalArgumentException("Failed to instantiate Transformer class <" + transformerClass.getCanonicalName() + ">");
            }
            transformers.add(new Module.Transformer(transformer, annotation.priorityWeighting(), annotation.sourceTypes()));
        }
        return transformers;
    }
}

