/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.invocation;

import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.devkit.dynamic.api.helper.LifeCycles;
import org.mule.devkit.dynamic.api.helper.MuleContexts;
import org.mule.devkit.dynamic.api.helper.Reflections;
import org.mule.devkit.dynamic.api.invocation.DynamicModule;

public class Registrar
implements Stoppable {
    private final MuleContext context;
    private final MessageSource messageSource;

    public Registrar(MuleContext context, MessageSource messageSource) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (messageSource == null) {
            throw new IllegalArgumentException("null messageSource");
        }
        this.context = context;
        this.messageSource = messageSource;
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialise() throws InitialisationException, MuleException {
        MuleContexts.inject(this.messageSource, this.context);
        LifeCycles.initialise(this.messageSource);
    }

    public final void start(Map<String, Object> sourceParameters, DynamicModule.Listener<?> listener) throws MuleException {
        Reflections.set(this.messageSource, sourceParameters);
        this.messageSource.setListener(new ListenerWrapper(listener));
        LifeCycles.start(this.messageSource);
    }

    public final void stop() throws MuleException {
        LifeCycles.stop(this.messageSource);
    }

    private static class ListenerWrapper<T>
    implements MessageProcessor {
        private final DynamicModule.Listener<T> listener;

        private ListenerWrapper(DynamicModule.Listener<T> listener) {
            if (listener == null) {
                throw new IllegalArgumentException("null listener");
            }
            this.listener = listener;
        }

        public final MuleEvent process(MuleEvent event) throws MuleException {
            this.listener.onEvent(event.getMessage().getPayload());
            return event;
        }
    }
}

