/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.ConnectionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.devkit.dynamic.api.helper.ConnectionManagers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    private final String name;
    private final String minMuleVersion;
    private final Capabilities module;
    private final List<Parameter> parameters;
    private final List<Processor> processors;
    private final List<Source> sources;
    private final List<Transformer> transformers;
    private final ClassLoader classLoader;
    private final ConnectionManager<?, ?> connectionManager;

    public Module(String name, String minMuleVersion, Capabilities module, List<Parameter> parameters, List<Processor> processors, List<Source> sources, List<Transformer> transformers, ConnectionManager<?, ?> connectionManager, ClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (minMuleVersion == null) {
            throw new IllegalArgumentException("null minMuleVersion");
        }
        if (module == null) {
            throw new IllegalArgumentException("null modules");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("null parameters");
        }
        if (processors == null) {
            throw new IllegalArgumentException("null processors");
        }
        if (sources == null) {
            throw new IllegalArgumentException("null sources");
        }
        if (transformers == null) {
            throw new IllegalArgumentException("null transformers");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("null classLoader");
        }
        this.name = name;
        this.minMuleVersion = minMuleVersion;
        this.module = module;
        this.parameters = Collections.unmodifiableList(new ArrayList<Parameter>(parameters));
        this.processors = Collections.unmodifiableList(new ArrayList<Processor>(processors));
        this.sources = Collections.unmodifiableList(new ArrayList<Source>(sources));
        this.transformers = Collections.unmodifiableList(new ArrayList<Transformer>(transformers));
        this.classLoader = classLoader;
        this.connectionManager = connectionManager;
        if (connectionManager != null) {
            this.ensureConnectionManagementCapability();
        }
    }

    protected final void ensureCapability(Capability capability) {
        if (!this.module.isCapableOf(capability)) {
            throw new IllegalArgumentException("Module does not support " + Capability.CONNECTION_MANAGEMENT_CAPABLE);
        }
    }

    protected final void ensureConnectionManagementCapability() {
        this.ensureCapability(Capability.CONNECTION_MANAGEMENT_CAPABLE);
    }

    public final String getName() {
        return this.name;
    }

    public final String getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public final Capabilities getModule() {
        return this.module;
    }

    public Object getModuleObject() {
        if (this.getConnectionManager() != null) {
            return this.getConnectionManager();
        }
        return this.getModule();
    }

    public final List<Parameter> getParameters() {
        return this.parameters;
    }

    public final List<Processor> getProcessors() {
        return this.processors;
    }

    public final List<Source> getSources() {
        return this.sources;
    }

    public final List<Transformer> getTransformers() {
        return this.transformers;
    }

    public final ConnectionManager<?, ?> getConnectionManager() {
        return this.connectionManager;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void setUsername(String username) {
        this.ensureConnectionManagementCapability();
        ConnectionManagers.setUsername(this.connectionManager, username);
    }

    public final void setPassword(String password) {
        this.ensureConnectionManagementCapability();
        ConnectionManagers.setPassword(this.connectionManager, password);
    }

    public final void setSecurityToken(String securityToken) {
        this.ensureConnectionManagementCapability();
        ConnectionManagers.setSecurityToken(this.connectionManager, securityToken);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transformer {
        private final org.mule.api.transformer.Transformer transformer;
        private final int priorityWeighting;
        private final Class<?>[] sourceTypes;

        public Transformer(org.mule.api.transformer.Transformer transformer, int priorityWeighting, Class<?>[] sourceTypes) {
            if (transformer == null) {
                throw new IllegalArgumentException("null transformer");
            }
            if (sourceTypes == null) {
                throw new IllegalArgumentException("null sourceTypes");
            }
            this.transformer = transformer;
            this.priorityWeighting = priorityWeighting;
            this.sourceTypes = sourceTypes;
        }

        public final org.mule.api.transformer.Transformer getTransformer() {
            return this.transformer;
        }

        public final int getPriorityWeighting() {
            return this.priorityWeighting;
        }

        public final Class<?>[] getSourceTypes() {
            return this.sourceTypes;
        }

        public String toString() {
            return "type: <" + this.transformer.getClass().getName() + "> priorityWeighting: <" + this.priorityWeighting + "> sourceTypes: <" + Arrays.toString(this.sourceTypes) + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Source {
        private final String name;
        private final MessageSource messageSource;
        private final List<Parameter> parameters;

        public Source(String name, MessageSource messageSource, List<Parameter> parameters) {
            if (name == null) {
                throw new IllegalArgumentException("null name");
            }
            if (messageSource == null) {
                throw new IllegalArgumentException("null messageSource");
            }
            if (parameters == null) {
                throw new IllegalArgumentException("null parameters");
            }
            this.name = name;
            this.messageSource = messageSource;
            this.parameters = parameters;
        }

        public final String getName() {
            return this.name;
        }

        public final MessageSource getMessageSource() {
            return this.messageSource;
        }

        public final List<Parameter> getParameters() {
            return this.parameters;
        }

        public String toString() {
            return "name: <" + this.name + "> type: <" + this.messageSource.getClass().getName() + "> parameters: <" + this.parameters + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Processor {
        private final String name;
        private final MessageProcessor messageProcessor;
        private final List<Parameter> parameters;
        private final boolean intercepting;

        public Processor(String name, MessageProcessor messageProcessor, List<Parameter> parameters, boolean intercepting) {
            if (name == null) {
                throw new IllegalArgumentException("null name");
            }
            if (messageProcessor == null) {
                throw new IllegalArgumentException("null messageProcessor");
            }
            if (parameters == null) {
                throw new IllegalArgumentException("null parameters");
            }
            this.name = name;
            this.messageProcessor = messageProcessor;
            this.parameters = parameters;
            this.intercepting = intercepting;
        }

        public final String getName() {
            return this.name;
        }

        public final MessageProcessor getMessageProcessor() {
            return this.messageProcessor;
        }

        public final List<Parameter> getParameters() {
            return this.parameters;
        }

        public final boolean isIntercepting() {
            return this.intercepting;
        }

        public String toString() {
            return "name: <" + this.name + "> type: <" + this.messageProcessor.getClass().getName() + "> parameters: <" + this.parameters + "> intercepting: <" + this.intercepting + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter {
        private final String name;
        private final Class<?> type;
        private final boolean optional;
        private final String defaultValue;

        public Parameter(String name, Class<?> type, boolean optional, String defaultValue) {
            if (name == null) {
                throw new IllegalArgumentException("null name");
            }
            if (type == null) {
                throw new IllegalArgumentException("null type");
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.defaultValue = defaultValue;
        }

        public final String getName() {
            return this.name;
        }

        public final Class<?> getType() {
            return this.type;
        }

        public final boolean isOptional() {
            return this.optional;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Parameter)) {
                return false;
            }
            Module module = (Module)other;
            return this.name.equals(module.name);
        }

        public String toString() {
            return "name: <" + this.name + "> optional: <" + this.optional + ">" + (this.defaultValue != null ? " default: <" + this.defaultValue + ">" : "");
        }
    }
}

