/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.invocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.dynamic.api.helper.LifeCycles;
import org.mule.devkit.dynamic.api.helper.MuleContexts;
import org.mule.devkit.dynamic.api.helper.Parameters;
import org.mule.devkit.dynamic.api.helper.Reflections;
import org.mule.devkit.dynamic.api.invocation.Invoker;
import org.mule.devkit.dynamic.api.invocation.Registrar;
import org.mule.devkit.dynamic.api.model.Module;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicModule
implements Disposable {
    private static final Logger LOGGER = Logger.getLogger(DynamicModule.class.getPackage().getName());
    private final MuleContext context;
    private final Module module;
    private static final String MODULE_OBJECT_REGISTRY_KEY = "moduleObject";
    private final int retryMax;
    protected static final int DEFAULT_RETRY_MAX = 5;
    private final Map<String, Object> parameters;
    private final Map<Class<?>, Invoker> invokerCache = new HashMap();
    private final Map<Class<?>, Registrar> registrarCache = new HashMap();

    public DynamicModule(Module module) {
        this(module, Collections.emptyMap());
    }

    public DynamicModule(Module module, Map<String, Object> overriddenParameters) {
        this(module, overriddenParameters, 5);
    }

    public DynamicModule(Module module, Map<String, Object> overriddenParameters, int retryMax) {
        if (module == null) {
            throw new IllegalArgumentException("null module");
        }
        if (overriddenParameters == null) {
            throw new IllegalArgumentException("null overriddenParameters");
        }
        if (retryMax <= 0) {
            throw new IllegalArgumentException("retryMax must be > 0");
        }
        this.validateParameterTypeCorrectness(module.getParameters(), overriddenParameters);
        this.ensureNoMissingParameters(module.getParameters(), overriddenParameters);
        try {
            this.context = MuleContexts.defaultMuleContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.module = module;
        this.retryMax = retryMax;
        this.parameters = this.allParameters(module.getParameters(), overriddenParameters);
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final MuleContext getMuleContext() {
        return this.context;
    }

    private void initialise() throws InitialisationException, RegistrationException, MuleException {
        Capabilities capabilities = this.module.getModule();
        if (capabilities.isCapableOf(Capability.LIFECYCLE_CAPABLE)) {
            LifeCycles.initialise(capabilities);
            LifeCycles.start(capabilities);
        }
        if (this.module.getConnectionManager() != null) {
            LifeCycles.initialise(this.module.getConnectionManager());
        }
        Object moduleObject = this.module.getModuleObject();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            Reflections.set(moduleObject, entry.getKey(), entry.getValue());
        }
        this.context.getRegistry().registerObject(MODULE_OBJECT_REGISTRY_KEY, moduleObject);
    }

    protected final void validateParameterTypeCorrectness(List<Module.Parameter> defaultParameters, Map<String, Object> overriddenParameters) {
        LinkedList<String> incorrectParameterTypes = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : overriddenParameters.entrySet()) {
            Class<?> type;
            Class<?> expectedType;
            String parameterName = entry.getKey();
            Module.Parameter parameter = Parameters.getParameter(defaultParameters, parameterName);
            if (parameter == null || (expectedType = Reflections.asType(parameter.getType())).isAssignableFrom(type = entry.getValue().getClass())) continue;
            StringBuilder details = new StringBuilder(parameterName);
            details.append("(type ").append(type.getCanonicalName()).append(" is not assignable to ").append(expectedType.getCanonicalName()).append(")");
            incorrectParameterTypes.add(details.toString());
        }
        if (!incorrectParameterTypes.isEmpty()) {
            String terminaison = incorrectParameterTypes.size() > 1 ? "s" : "";
            throw new IllegalArgumentException("Incorrect type" + terminaison + " for parameter" + terminaison + " <" + incorrectParameterTypes + ">");
        }
    }

    protected final void ensureNoMissingParameters(List<Module.Parameter> defaultParameters, Map<String, Object> overriddenParameters) {
        LinkedList<String> missingMandatoryParameters = new LinkedList<String>();
        for (Module.Parameter parameter : defaultParameters) {
            if (parameter.isOptional() || parameter.getDefaultValue() != null || overriddenParameters.containsKey(parameter.getName())) continue;
            missingMandatoryParameters.add(parameter.getName());
        }
        if (!missingMandatoryParameters.isEmpty()) {
            String terminaison = missingMandatoryParameters.size() > 1 ? "s" : "";
            throw new IllegalArgumentException("Value" + terminaison + " for parameter" + terminaison + " <" + missingMandatoryParameters + "> must be provided");
        }
    }

    protected final Map<String, Object> allParameters(List<Module.Parameter> defaultParameters, Map<String, Object> overriddenParameters) {
        HashMap<String, Object> allParameters = new HashMap<String, Object>();
        HashSet<String> defaultParameterNames = new HashSet<String>();
        for (Module.Parameter parameter : defaultParameters) {
            if (parameter.getDefaultValue() != null) {
                try {
                    Transformer transformer = this.context.getRegistry().lookupTransformer(DataType.STRING_DATA_TYPE, DataTypeFactory.create(parameter.getType()));
                    allParameters.put(parameter.getName(), transformer.transform((Object)parameter.getDefaultValue()));
                }
                catch (TransformerException e) {
                    throw new RuntimeException("Failed to transform <" + parameter.getDefaultValue() + ">", e);
                }
            }
            defaultParameterNames.add(parameter.getName());
        }
        for (Map.Entry entry : overriddenParameters.entrySet()) {
            String parameterName = (String)entry.getKey();
            if (!defaultParameterNames.contains(parameterName)) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Value has been provided for unknown parameter <{0}>; it will be ignored", parameterName);
                continue;
            }
            allParameters.put(parameterName, entry.getValue());
        }
        return allParameters;
    }

    protected final Module.Processor findProcessor(String processorName) {
        for (Module.Processor processor : this.module.getProcessors()) {
            if (!processorName.equals(processor.getName())) continue;
            return processor;
        }
        return null;
    }

    protected final synchronized Invoker getInvoker(MessageProcessor messageProcessor) throws InitialisationException, MuleException {
        Class<?> key = messageProcessor.getClass();
        if (this.invokerCache.containsKey(key)) {
            return this.invokerCache.get(key);
        }
        Invoker invoker = new Invoker(this.context, messageProcessor, this.retryMax);
        this.invokerCache.put(key, invoker);
        return invoker;
    }

    public final <T> T invoke(String processorName, Map<String, Object> overriddenParameters) throws InitialisationException, MuleException {
        if (processorName == null) {
            throw new IllegalArgumentException("The processor name cannot be null");
        }
        if (overriddenParameters == null) {
            throw new IllegalArgumentException("The overridenParameters cannot be null");
        }
        Module.Processor processor = this.findProcessor(processorName);
        if (processor == null) {
            throw new IllegalArgumentException("Cannot find a Processor named <" + processorName + ">");
        }
        this.validateParameterTypeCorrectness(processor.getParameters(), overriddenParameters);
        this.ensureNoMissingParameters(processor.getParameters(), overriddenParameters);
        return this.invoke(processor.getMessageProcessor(), this.allParameters(processor.getParameters(), overriddenParameters));
    }

    protected <T> T invoke(MessageProcessor messageProcessor, Map<String, Object> parameters) throws InitialisationException, MuleException {
        return this.getInvoker(messageProcessor).invoke(parameters);
    }

    protected final Module.Source findSource(String sourceName) {
        for (Module.Source source : this.module.getSources()) {
            if (!sourceName.equals(source.getName())) continue;
            return source;
        }
        return null;
    }

    protected final synchronized Registrar getRegistrar(MessageSource messageSource) throws InitialisationException, MuleException {
        Class<?> key = messageSource.getClass();
        return this.registrarCache.get(key);
    }

    protected final synchronized Registrar createAndCacheRegistrar(MessageSource messageSource) {
        Class<?> key = messageSource.getClass();
        Registrar registrar = new Registrar(this.context, messageSource);
        this.registrarCache.put(key, registrar);
        return registrar;
    }

    public final synchronized void subscribe(String sourceName, Map<String, Object> overriddenParameters, Listener listener) throws InitialisationException, MuleException {
        if (sourceName == null) {
            throw new IllegalArgumentException("null sourceName");
        }
        if (overriddenParameters == null) {
            throw new IllegalArgumentException("null overriddenParameters");
        }
        Module.Source source = this.findSource(sourceName);
        if (source == null) {
            throw new IllegalArgumentException("Cannot find a Source named <" + sourceName + ">");
        }
        this.validateParameterTypeCorrectness(source.getParameters(), overriddenParameters);
        this.ensureNoMissingParameters(source.getParameters(), overriddenParameters);
        Registrar registrar = this.getRegistrar(source.getMessageSource());
        if (registrar != null) {
            throw new IllegalStateException("Source <" + sourceName + "> is already subscribed");
        }
        this.createAndCacheRegistrar(source.getMessageSource()).start(this.allParameters(source.getParameters(), overriddenParameters), listener);
    }

    public final void unsubscribe(String sourceName) throws MuleException {
        if (sourceName == null) {
            throw new IllegalArgumentException("null sourceName");
        }
        Module.Source source = this.findSource(sourceName);
        if (source == null) {
            throw new IllegalArgumentException("Cannot find a Source named <" + sourceName + ">");
        }
        Registrar registrar = this.getRegistrar(source.getMessageSource());
        if (registrar == null) {
            throw new IllegalStateException("Source <" + sourceName + "> is not subscribed");
        }
        registrar.stop();
    }

    public final void dispose() {
        for (Invoker invoker : this.invokerCache.values()) {
            invoker.dispose();
        }
        for (Registrar registrar : this.registrarCache.values()) {
            try {
                registrar.stop();
            }
            catch (MuleException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Got exception while closing <" + registrar + ">", e);
            }
        }
        this.context.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener<T> {
        public void onEvent(T var1);
    }
}

