<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= CONFIGURATION DETAIL ======== -->
<A NAME="<?cs var:class.moduleConfigElementName ?>"></A>
<h2>Configuration</h2>
<p>To use the this module within a flow the namespace to the module must be included. The resulting flow will look
similar to the following:</p>
<pre>
&lt;mule xmlns="http://www.mulesoft.org/schema/mule/core"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xmlns:<?cs var:class.moduleName ?>="<?cs var:class.moduleNamespace ?>"
      xsi:schemaLocation="
               http://www.mulesoft.org/schema/mule/core
               http://www.mulesoft.org/schema/mule/core/current/mule.xsd
               <?cs var:class.moduleNamespace ?>
               <?cs var:class.moduleSchemaLocation ?>"&gt;

      &lt;!-- here goes your flows and configuration elements --&gt;

&lt;/mule&gt;
</pre>
<?cs if:subcount(class.config) ?>
<p>This module is configured using the <i>config</i> element. This element must be placed outside of your flows and at
the root of your Mule application. You can create as many configurations as you deem necessary as long as each carries
its own name.</p>
<p>Each message processor, message source or transformer carries a <i>config-ref</i> attribute that allows the invoker to
specify which configuration to use.</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">Attributes</th></tr>
<tr><th>Type</th><th>Name</th><th>Default Value</th><th>Description</th><th>Java Type</th><th>MIME Type</th><th>Encoding</th></tr>
<td class="jd-typecol"><nobr>xs:string</nobr></td>
<td class="jd-linkcol"><nobr>name</nobr></td>
<td class="jd-descrcol"></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Give a name to this configuration so it can be later referenced.</td>
<td/><td/><td/>
<?cs set:count = #2 ?>
    <?cs each:field=class.config ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>
          <?cs var:field.type.xmlName ?></nobr></td>
          <td class="jd-linkcol"><nobr><?cs var:field.name ?></nobr></td>
          <td class="jd-descrcol"><?cs var:field.defaultValue ?></td>
          <td class="jd-descrcol" width="100%"><?cs if:field.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:short_descr(field) ?></td>
          <td class="jd-descrcol"><?cs if:field.useLinkForClass=="true" ?><?cs call:type_link(field.type)?><?cs else ?><?cs var:field.label ?><?cs /if ?></td>
          <td class="jd-descrcol"><?cs var:field.mimeType ?></td>
          <td class="jd-descrcol"><?cs var:field.encoding ?></td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /each ?>
    <?cs if:class.moduleOAuth1Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>xs:string</nobr></td>
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>xs:string</nobr></td>
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>xs:string</nobr></td>
          <td class="jd-linkcol"><nobr>requestTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthRequestTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider used to obtain an un-authorized request token</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>
    <?cs if:class.moduleOAuth2Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>xs:string</nobr></td>
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-typecol"><nobr>xs:string</nobr></td>
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>
</table>
<?cs call:sample_config(class.descr) ?>
<?cs /if ?>
