/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.InheritedTags;
import org.mule.devkit.doclet.SourcePositionInfo;

public class TagInfo {
    private String mName;
    private String mText;
    private String mKind;
    private SourcePositionInfo mPosition;

    TagInfo(String n, String k, String t, SourcePositionInfo sp) {
        this.mName = n;
        this.mText = t;
        this.mKind = k;
        this.mPosition = sp;
    }

    String name() {
        return this.mName;
    }

    String text() {
        return this.mText;
    }

    String kind() {
        return this.mKind;
    }

    SourcePositionInfo position() {
        return this.mPosition;
    }

    void setKind(String kind) {
        this.mKind = kind;
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".text", this.text());
        data.setValue(base + ".kind", this.kind());
    }

    public static void makeHDF(Data data, String base, TagInfo[] tags) {
        TagInfo.makeHDF(data, base, tags, null, 0, 0);
    }

    public static void makeHDF(Data data, String base, InheritedTags tags) {
        TagInfo.makeHDF(data, base, tags.tags(), tags.inherited(), 0, 0);
    }

    private static int makeHDF(Data data, String base, TagInfo[] tags, InheritedTags inherited, int j, int depth) {
        int len = tags.length;
        if (len == 0 && inherited != null) {
            j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
        } else {
            int i = 0;
            while (i < len) {
                TagInfo t = tags[i];
                if (inherited != null && t.name().equals("@inheritDoc")) {
                    j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
                } else {
                    if (t.name().equals("@inheritDoc")) {
                        Errors.error(Errors.BAD_INHERITDOC, t.mPosition, "@inheritDoc on class/method that is not inherited");
                    }
                    t.makeHDF(data, base + "." + j);
                }
                ++i;
                ++j;
            }
        }
        return j;
    }

    static boolean tagsEqual(TagInfo[] first, TagInfo[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (!first[i].mName.equals(second[i].mName)) {
                return false;
            }
            if (!first[i].mKind.equals(second[i].mKind)) {
                return false;
            }
            if (first[i].mText.equals(second[i].mText)) continue;
            return false;
        }
        return true;
    }
}

