/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotations.Paged;
import org.mule.devkit.doclet.AnnotationInstanceInfo;
import org.mule.devkit.doclet.AnnotationValueInfo;
import org.mule.devkit.doclet.AttrTagInfo;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.InheritedTags;
import org.mule.devkit.doclet.MemberInfo;
import org.mule.devkit.doclet.ParamTagInfo;
import org.mule.devkit.doclet.ParameterInfo;
import org.mule.devkit.doclet.SeeTagInfo;
import org.mule.devkit.doclet.SinceTagger;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.ThrowsTagInfo;
import org.mule.devkit.doclet.TypeInfo;
import org.mule.devkit.doclet.apicheck.AbstractMethodInfo;

public class MethodInfo
extends MemberInfo
implements AbstractMethodInfo {
    private static final String DEFAULT_MIME_TYPE = "*/*";
    private boolean hasChildElements;
    public static final Comparator<MethodInfo> comparator = new Comparator<MethodInfo>(){

        @Override
        public int compare(MethodInfo a, MethodInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private String mFlatSignature;
    private MethodInfo mOverriddenMethod;
    private TypeInfo mReturnType;
    private boolean mIsAnnotationElement;
    private boolean mIsAbstract;
    private boolean mIsSynchronized;
    private boolean mIsNative;
    private boolean mIsVarargs;
    private boolean mDeprecatedKnown;
    private boolean mIsDeprecated;
    private boolean mProcessorKnown;
    private boolean mIsProcessor;
    private String mCategoryName;
    private String mCategoryDescription;
    private boolean mHasCategory;
    private boolean mCategoryKnown;
    private boolean mSourceKnown;
    private boolean mIsSource;
    private boolean mTransformerKnown;
    private boolean mIsTransformer;
    private boolean mIsPagedKnown;
    private boolean mIsPaged;
    private boolean isPagedFetchSizeKnown;
    private String pagedFetchSize;
    private String mElementName;
    private ParameterInfo[] mParameters;
    private ClassInfo[] mThrownExceptions;
    private String[] mParamStrings;
    ThrowsTagInfo[] mThrowsTags;
    private ParamTagInfo[] mParamTags;
    private TypeInfo[] mTypeParameters;
    private AnnotationValueInfo mDefaultAnnotationElementValue;
    private String mReasonOpened;

    public String relativeModulePath() {
        String s = this.mContainingClass.moduleName() + "-" + this.mContainingClass.moduleConfigElementName();
        s = s + ".html";
        s = s + "#" + this.elementName();
        return s;
    }

    private static void addInterfaces(ClassInfo[] ifaces, ArrayList<ClassInfo> queue) {
        for (ClassInfo i : ifaces) {
            queue.add(i);
        }
        for (ClassInfo i : ifaces) {
            MethodInfo.addInterfaces(i.getInterfaces(), queue);
        }
    }

    public MethodInfo findOverriddenMethod(String name, String signature) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        MethodInfo.addInterfaces(this.containingClass().getInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0) continue;
                return me;
            }
        }
        return null;
    }

    public MethodInfo findRealOverriddenMethod(MethodInfo other, HashSet<ClassInfo> notStrippable) {
        String name = other.name();
        String signature = other.signature();
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0 || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public MethodInfo findSuperclassImplementation(HashSet notStrippable) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null && this.signature().equals(this.mOverriddenMethod.signature())) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(this.name()) || !me.signature().equals(this.signature()) || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public ClassInfo findRealOverriddenClass(String name, String signature) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod.mRealContainingClass;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0) continue;
                return iface;
            }
        }
        return null;
    }

    public boolean isDeprecated() {
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().isDeprecated();
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (annotation == null || annotation.type() == null || !"java.lang.Deprecated".equals(annotation.type().qualifiedName())) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Method " + this.mContainingClass.qualifiedName() + "." + this.name() + ": @Deprecated annotation and @deprecated doc tag do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public boolean hasCategory() {
        if (!this.mCategoryKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Category")) continue;
                for (AnnotationValueInfo value : annotation.elementValues()) {
                    if ("name".equals(value.element().name())) {
                        this.mCategoryName = value.valueString().replace("\"", "");
                    }
                    if (!"description".equals(value.element().name())) continue;
                    this.mCategoryDescription = value.valueString().replace("\"", "");
                }
                annotationPresent = true;
                break;
            }
            this.mHasCategory = annotationPresent;
            this.mCategoryKnown = true;
            if (!annotationPresent && (this.isProcessor() || this.isSource() || this.isTransformer())) {
                this.mHasCategory = true;
                this.mCategoryKnown = true;
                this.mCategoryDescription = "";
                this.mCategoryName = this.isProcessor() ? "Message Processors" : (this.isTransformer() ? "Transformers" : "Message Sources");
            }
        }
        return this.mHasCategory;
    }

    public String getCategoryName() {
        return this.mCategoryName;
    }

    public String getCategoryDescription() {
        return this.mCategoryDescription;
    }

    public String uncamel(String camelCaseName) {
        String result = "";
        String[] parts = camelCaseName.split("(?<!^)(?=[A-Z])");
        for (int i = 0; i < parts.length; ++i) {
            result = result + parts[i].toLowerCase() + (i < parts.length - 1 ? "-" : "");
        }
        return result;
    }

    public boolean isProcessor() {
        if (!this.mProcessorKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Processor")) continue;
                this.mElementName = this.uncamel(this.name());
                for (AnnotationValueInfo value : annotation.elementValues()) {
                    if (!"name".equals(value.element().name())) continue;
                    this.mElementName = value.valueString().replace("\"", "");
                }
                annotationPresent = true;
                break;
            }
            this.mIsProcessor = annotationPresent;
            this.mProcessorKnown = true;
        }
        return this.mIsProcessor;
    }

    public boolean isSource() {
        if (!this.mSourceKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Source")) continue;
                this.mElementName = this.uncamel(this.name());
                for (AnnotationValueInfo value : annotation.elementValues()) {
                    if (!"name".equals(value.element().name())) continue;
                    this.mElementName = value.valueString().replace("\"", "");
                }
                annotationPresent = true;
                break;
            }
            this.mIsSource = annotationPresent;
            this.mSourceKnown = true;
        }
        return this.mIsSource;
    }

    public boolean isTransformer() {
        if (!this.mTransformerKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Transformer")) continue;
                this.mElementName = this.uncamel(this.name());
                for (AnnotationValueInfo value : annotation.elementValues()) {
                    if (!"name".equals(value.element().name())) continue;
                    this.mElementName = value.valueString().replace("\"", "");
                }
                annotationPresent = true;
                break;
            }
            this.mIsTransformer = annotationPresent;
            this.mTransformerKnown = true;
        }
        return this.mIsTransformer;
    }

    public boolean isPaged() {
        if (!this.mIsPagedKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals(Paged.class.getName())) continue;
                this.mElementName = this.uncamel(this.name());
                for (AnnotationValueInfo value : annotation.elementValues()) {
                    if (!"name".equals(value.element().name())) continue;
                    this.mElementName = value.valueString().replace("\"", "");
                }
                annotationPresent = true;
                break;
            }
            this.mIsPaged = annotationPresent;
            this.mIsPagedKnown = true;
        }
        return this.mIsPaged;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.mDeprecatedKnown = true;
        this.mIsDeprecated = deprecated;
    }

    public TypeInfo[] getTypeParameters() {
        return this.mTypeParameters;
    }

    public MethodInfo cloneForClass(ClassInfo newContainingClass) {
        MethodInfo result = new MethodInfo(this.getRawCommentText(), this.mTypeParameters, this.name(), this.signature(), newContainingClass, this.realContainingClass(), this.isPublic(), this.isProtected(), this.isPackagePrivate(), this.isPrivate(), this.isFinal(), this.isStatic(), this.isSynthetic(), this.mIsAbstract, this.mIsSynchronized, this.mIsNative, this.mIsAnnotationElement, this.kind(), this.mFlatSignature, this.mOverriddenMethod, this.mReturnType, this.mParameters, this.mThrownExceptions, this.position(), this.annotations());
        result.init(this.mDefaultAnnotationElementValue);
        return result;
    }

    public MethodInfo(String rawCommentText, TypeInfo[] typeParameters, String name, String signature, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isSynthetic, boolean isAbstract, boolean isSynchronized, boolean isNative, boolean isAnnotationElement, String kind, String flatSignature, MethodInfo overriddenMethod, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] thrownExceptions, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, name, signature, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, name.equals("values") && containingClass.isEnum() ? true : isFinal, isStatic, isSynthetic, kind, position, annotations);
        if (containingClass.isInterface()) {
            isAbstract = true;
        }
        this.mReasonOpened = "0:0";
        this.mIsAnnotationElement = isAnnotationElement;
        this.mTypeParameters = typeParameters;
        this.mIsAbstract = isAbstract;
        this.mIsSynchronized = isSynchronized;
        this.mIsNative = isNative;
        this.mFlatSignature = flatSignature;
        this.mOverriddenMethod = overriddenMethod;
        this.mReturnType = returnType;
        this.mParameters = parameters;
        this.mThrownExceptions = thrownExceptions;
    }

    public void init(AnnotationValueInfo defaultAnnotationElementValue) {
        this.mDefaultAnnotationElementValue = defaultAnnotationElementValue;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public boolean isSynchronized() {
        return this.mIsSynchronized;
    }

    public boolean isNative() {
        return this.mIsNative;
    }

    public String flatSignature() {
        return this.mFlatSignature;
    }

    public String elementName() {
        return this.mElementName;
    }

    public InheritedTags inlineTags() {
        return new InlineTags();
    }

    public InheritedTags firstSentenceTags() {
        return new FirstSentenceTags();
    }

    public InheritedTags returnTags() {
        return new ReturnTags();
    }

    public InheritedTags apiTags() {
        return new APITags();
    }

    public TypeInfo returnType() {
        return this.mReturnType;
    }

    public String prettySignature() {
        return this.name() + this.prettyParameters();
    }

    public String prettyParameters() {
        StringBuilder params = new StringBuilder("(");
        for (ParameterInfo pInfo : this.mParameters) {
            if (params.length() > 1) {
                params.append(",");
            }
            params.append(pInfo.type().simpleTypeName());
        }
        params.append(")");
        return params.toString();
    }

    public String getHashableName() {
        StringBuilder result = new StringBuilder();
        result.append(this.name());
        for (int p = 0; p < this.mParameters.length; ++p) {
            result.append(":");
            if (p == this.mParameters.length - 1 && this.isVarArgs()) {
                result.append(this.mParameters[p].type().fullNameNoDimension(this.typeVariables())).append("...");
                continue;
            }
            result.append(this.mParameters[p].type().fullName(this.typeVariables()));
        }
        return result.toString();
    }

    private boolean inList(ClassInfo item, ThrowsTagInfo[] list) {
        int len = list.length;
        String qn = item.qualifiedName();
        for (int i = 0; i < len; ++i) {
            ClassInfo ex = list[i].exception();
            if (ex == null || !ex.qualifiedName().equals(qn)) continue;
            return true;
        }
        return false;
    }

    public ThrowsTagInfo[] throwsTags() {
        if (this.mThrowsTags == null) {
            ThrowsTagInfo[] documented = this.comment().throwsTags();
            ArrayList<ThrowsTagInfo> rv = new ArrayList<ThrowsTagInfo>();
            int len = documented.length;
            for (int i = 0; i < len; ++i) {
                if (documented[i].exception() == null) continue;
                rv.add(documented[i]);
            }
            for (ClassInfo cl : this.mThrownExceptions) {
                if (documented != null && this.inList(cl, documented)) continue;
                rv.add(new ThrowsTagInfo("@throws", "@throws", cl.qualifiedName(), cl, "", this.containingClass(), this.position()));
            }
            this.mThrowsTags = rv.toArray(new ThrowsTagInfo[rv.size()]);
        }
        return this.mThrowsTags;
    }

    private static int indexOfParam(String name, String[] list) {
        int N = list.length;
        for (int i = 0; i < N; ++i) {
            if (!name.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    public ParamTagInfo[] paramTags() {
        if (this.mParamTags == null) {
            int N = this.mParameters.length;
            String[] names = new String[N];
            boolean[] optional = new boolean[N];
            boolean[] nestedProcessor = new boolean[N];
            boolean[] collection = new boolean[N];
            String[] defaultValue = new String[N];
            String[] attributeName = new String[N];
            String[] comments = new String[N];
            String[] mimeTypes = new String[N];
            SourcePositionInfo[] positions = new SourcePositionInfo[N];
            for (int i = 0; i < N; ++i) {
                attributeName[i] = this.mParameters[i].name();
                nestedProcessor[i] = false;
                collection[i] = false;
                if (this.mParameters[i].typeName().startsWith("List") || this.mParameters[i].typeName().startsWith("java.util.List") || this.mParameters[i].typeName().startsWith("ArrayList") || this.mParameters[i].typeName().startsWith("java.util.ArrayList") || this.mParameters[i].typeName().startsWith("Map") || this.mParameters[i].typeName().startsWith("java.util.Map") || this.mParameters[i].typeName().startsWith("HashMap") || this.mParameters[i].typeName().startsWith("java.util.HashMap")) {
                    attributeName[i] = this.uncamel(attributeName[i]);
                    collection[i] = true;
                    this.hasChildElements = true;
                }
                if (this.mParameters[i].typeName().contains("HttpCallback")) {
                    attributeName[i] = this.uncamel(attributeName[i]) + "-flow-ref";
                }
                if (this.mParameters[i].typeName().contains("NestedProcessor")) {
                    attributeName[i] = this.uncamel(attributeName[i]);
                    nestedProcessor[i] = true;
                    this.hasChildElements = true;
                }
                optional[i] = false;
                defaultValue[i] = "";
                for (AnnotationInstanceInfo annotation : this.mParameters[i].annotations()) {
                    if (annotation.type().qualifiedName().equals("org.mule.api.annotations.Parameter")) {
                        for (AnnotationValueInfo value : annotation.elementValues()) {
                            if (!"name".equals(value.element().name())) continue;
                            attributeName[i] = value.valueString().replace("\"", "");
                        }
                        break;
                    }
                    if (annotation.type().qualifiedName().equals("org.mule.api.annotations.param.Optional")) {
                        optional[i] = true;
                        continue;
                    }
                    if (annotation.type().qualifiedName().equals("org.mule.api.annotations.param.Default")) {
                        defaultValue[i] = annotation.elementValues()[0].valueString().replace("\"", "");
                        continue;
                    }
                    if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Mime")) continue;
                    mimeTypes[i] = annotation.elementValues()[0].valueString().replace("\"", "");
                }
                names[i] = this.mParameters[i].name();
                comments[i] = "";
                positions[i] = this.mParameters[i].position();
                if (mimeTypes[i] != null) continue;
                mimeTypes[i] = DEFAULT_MIME_TYPE;
            }
            for (ParamTagInfo tag : this.comment().paramTags()) {
                int index = MethodInfo.indexOfParam(tag.parameterName(), names);
                if (index >= 0) {
                    comments[index] = StringUtils.capitalize((String)tag.parameterComment());
                    positions[index] = tag.position();
                    continue;
                }
                Errors.error(Errors.UNKNOWN_PARAM_TAG_NAME, tag.position(), "@param tag with name that doesn't match the parameter list: '" + tag.parameterName() + "'");
            }
            MethodInfo overridden = this.findOverriddenMethod(this.name(), this.signature());
            if (overridden != null) {
                ParamTagInfo[] maternal = overridden.paramTags();
                for (int i = 0; i < N; ++i) {
                    if (!comments[i].equals("")) continue;
                    comments[i] = maternal[i].parameterComment();
                    positions[i] = maternal[i].position();
                }
            }
            this.mParamTags = new ParamTagInfo[N];
            for (int i = 0; i < N; ++i) {
                this.mParamTags[i] = new ParamTagInfo("@param", "@param", names[i] + " " + comments[i], attributeName[i], optional[i], defaultValue[i], nestedProcessor[i], collection[i], this.parent(), positions[i], this.mParameters[i].mType, mimeTypes[i]);
                if (!comments[i].equals("")) continue;
                Errors.error(Errors.UNDOCUMENTED_PARAMETER, positions[i], "Undocumented parameter '" + names[i] + "' on method '" + this.name() + "'");
            }
        }
        return this.mParamTags;
    }

    public SeeTagInfo[] seeTags() {
        SeeTagInfo[] result = this.comment().seeTags();
        if (result == null && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.seeTags();
        }
        return result;
    }

    public TagInfo[] deprecatedTags() {
        TagInfo[] result = this.comment().deprecatedTags();
        if (result.length == 0 && this.comment().undeprecateTags().length == 0 && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.deprecatedTags();
        }
        return result;
    }

    public ParameterInfo[] parameters() {
        return this.mParameters;
    }

    public boolean matchesParams(String[] params, String[] dimensions, boolean varargs) {
        if (this.mParamStrings == null) {
            ParameterInfo[] mine = this.mParameters;
            int len = mine.length;
            if (len != params.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (!mine[i].matchesDimension(dimensions[i], varargs)) {
                    return false;
                }
                TypeInfo myType = mine[i].type();
                String qualifiedName = myType.qualifiedTypeName();
                String realType = myType.isPrimitive() ? "" : myType.asClassInfo().qualifiedName();
                String s = params[i];
                if (this.matchesType(qualifiedName, s) || this.matchesType(realType, s)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchesType(String signatureParam, String callerParam) {
        int signatureLength = signatureParam.length();
        int callerLength = callerParam.length();
        return signatureParam.equals(callerParam) || callerLength + 1 < signatureLength && signatureParam.charAt(signatureLength - callerLength - 1) == '.' && signatureParam.endsWith(callerParam);
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".kind", this.kind());
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".elementName", this.elementName());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".modhref", this.relativeModulePath());
        data.setValue(base + ".anchor", this.anchor());
        if (this.mReturnType != null) {
            this.returnType().makeHDF(data, base + ".returnType", false, this.typeVariables());
            data.setValue(base + ".abstract", this.mIsAbstract ? "abstract" : "");
        }
        data.setValue(base + ".synchronized", this.mIsSynchronized ? "synchronized" : "");
        data.setValue(base + ".final", this.isFinal() ? "final" : "");
        data.setValue(base + ".static", this.isStatic() ? "static" : "");
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".descr", this.inlineTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        TagInfo.makeHDF(data, base + ".seeAlso", this.seeTags());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
        data.setValue(base + ".moduleName", this.containingClass().moduleName());
        ParamTagInfo.makeHDF(data, base + ".paramTags", this.paramTags());
        if (this.containingClass().hasConnectionManager()) {
            ParamTagInfo.makeHDF(data, base + ".connectionTags", this.containingClass().connectionTags());
        }
        data.setValue(base + ".hasConnectionManager", this.containingClass().hasConnectionManager() ? "1" : "0");
        data.setValue(base + ".hasOAuthManager", this.containingClass().hasOAuthManager() ? "1" : "0");
        data.setValue(base + ".hasChildElements", Boolean.toString(this.hasChildElements));
        data.setValue(base + ".isProcessor", this.isProcessor() ? "1" : "0");
        if (this.isPaged()) {
            data.setValue(base + ".isPaged", "1");
            data.setValue(base + ".paginatedValues.pagedFetchSize", this.getPagedFetchSize().toString());
        } else {
            data.setValue(base + ".isPaged", "0");
        }
        AttrTagInfo.makeReferenceHDF(data, base + ".attrRefs", this.comment().attrTags());
        ThrowsTagInfo.makeHDF(data, base + ".throws", this.throwsTags());
        ParameterInfo.makeHDF(data, base + ".params", this.parameters(), this.isVarArgs(), this.typeVariables());
        if (this.isProtected()) {
            data.setValue(base + ".scope", "protected");
        } else if (this.isPublic()) {
            data.setValue(base + ".scope", "public");
        }
        TagInfo.makeHDF(data, base + ".returns", this.returnTags());
        if (this.mReturnType != null) {
            this.mReturnType.makeHDF(data, base + ".returnPayload");
        }
        TagInfo.makeHDF(data, base + ".api", this.apiTags());
        if (this.mTypeParameters != null) {
            TypeInfo.makeHDF(data, base + ".generic.typeArguments", this.mTypeParameters, false);
        }
        this.setFederatedReferences(data, base);
    }

    private String getPagedFetchSize() {
        if (!this.isPagedFetchSizeKnown) {
            AnnotationInstanceInfo paged = null;
            for (AnnotationInstanceInfo annotationInstanceInfo : this.annotations()) {
                if (!annotationInstanceInfo.type().toString().equals(Paged.class.getName())) continue;
                paged = annotationInstanceInfo;
                break;
            }
            AnnotationValueInfo fetchSize = null;
            for (AnnotationValueInfo annotationValueInfo : paged.elementValues()) {
                if (!annotationValueInfo.element().name().equals("defaultFetchSize")) continue;
                fetchSize = annotationValueInfo;
                break;
            }
            Integer defaultFetchSizeValue = 100;
            if (fetchSize != null) {
                defaultFetchSizeValue = (Integer)fetchSize.value();
            }
            this.pagedFetchSize = defaultFetchSizeValue.toString();
            this.isPagedFetchSizeKnown = true;
        }
        return this.pagedFetchSize;
    }

    public HashSet<String> typeVariables() {
        HashSet<String> result = TypeInfo.typeVariables(this.mTypeParameters);
        for (ClassInfo cl = this.containingClass(); cl != null; cl = cl.containingClass()) {
            TypeInfo[] types = cl.asTypeInfo().typeArguments();
            if (types == null) continue;
            TypeInfo.typeVariables(types, result);
        }
        return result;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    public ClassInfo[] thrownExceptions() {
        return this.mThrownExceptions;
    }

    public String typeArgumentsName(HashSet<String> typeVars) {
        if (this.mTypeParameters == null || this.mTypeParameters.length == 0) {
            return "";
        }
        return TypeInfo.typeArgumentsName(this.mTypeParameters, typeVars);
    }

    public boolean isAnnotationElement() {
        return this.mIsAnnotationElement;
    }

    public AnnotationValueInfo defaultAnnotationElementValue() {
        return this.mDefaultAnnotationElementValue;
    }

    @Override
    public void setVarargs(boolean set) {
        this.mIsVarargs = set;
    }

    @Override
    public boolean isVarArgs() {
        return this.mIsVarargs;
    }

    public String toString() {
        return this.name();
    }

    public void setReason(String reason) {
        this.mReasonOpened = reason;
    }

    public String getReason() {
        return this.mReasonOpened;
    }

    @Override
    public void addException(String exec) {
        ClassInfo exceptionClass = new ClassInfo(exec);
        ArrayList<ClassInfo> exceptions = new ArrayList<ClassInfo>(this.mThrownExceptions.length + 1);
        exceptions.addAll(Arrays.asList(this.mThrownExceptions));
        exceptions.add(exceptionClass);
        this.mThrownExceptions = new ClassInfo[exceptions.size()];
        exceptions.toArray(this.mThrownExceptions);
    }

    @Override
    public void addParameter(ParameterInfo p) {
        TypeInfo[] newTypes;
        ParameterInfo[] newParams;
        int i = 0;
        if (this.mParameters == null) {
            newParams = new ParameterInfo[1];
        } else {
            newParams = new ParameterInfo[this.mParameters.length + 1];
            for (ParameterInfo info : this.mParameters) {
                newParams[i++] = info;
            }
        }
        newParams[i] = p;
        this.mParameters = newParams;
        i = 0;
        if (this.mTypeParameters == null) {
            newTypes = new TypeInfo[1];
        } else {
            newTypes = new TypeInfo[this.mTypeParameters.length + 1];
            for (TypeInfo info : this.mTypeParameters) {
                newTypes[i++] = info;
            }
        }
        newTypes[i] = p.mType;
        this.mTypeParameters = newTypes;
    }

    public String qualifiedName() {
        String parentQName = this.containingClass() != null ? this.containingClass().qualifiedName() + "." : "";
        return parentQName + this.name();
    }

    @Override
    public String signature() {
        if (this.mSignature == null) {
            StringBuilder params = new StringBuilder("(");
            for (ParameterInfo pInfo : this.mParameters) {
                if (params.length() > 1) {
                    params.append(", ");
                }
                params.append(pInfo.type().fullName());
            }
            params.append(")");
            this.mSignature = params.toString();
        }
        return this.mSignature;
    }

    public boolean matches(MethodInfo other) {
        return this.prettySignature().equals(other.prettySignature());
    }

    public boolean throwsException(ClassInfo exception) {
        for (ClassInfo e : this.mThrownExceptions) {
            if (!e.qualifiedName().equals(exception.qualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(MethodInfo mInfo) {
        boolean consistent = true;
        if (!this.mReturnType.equals(mInfo.mReturnType)) {
            consistent = false;
            Errors.error(Errors.CHANGED_TYPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed return type from " + this.mReturnType + " to " + mInfo.mReturnType);
        }
        if (this.mIsAbstract != mInfo.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'abstract' qualifier");
        }
        if (this.mIsNative != mInfo.mIsNative) {
            consistent = false;
            Errors.error(Errors.CHANGED_NATIVE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'native' qualifier");
        }
        if (!(this.mIsFinal == mInfo.mIsFinal || this.mIsStatic || this.containingClass() != null && this.containingClass().isFinal())) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'final' qualifier");
        }
        if (this.mIsStatic != mInfo.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'static' qualifier");
        }
        if (!this.scope().equals(mInfo.scope())) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " changed scope from " + this.scope() + " to " + mInfo.scope());
        }
        if (!this.isDeprecated() == mInfo.isDeprecated()) {
            Errors.error(Errors.CHANGED_DEPRECATED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed deprecation state");
            consistent = false;
        }
        if (this.mIsSynchronized != mInfo.mIsSynchronized) {
            Errors.error(Errors.CHANGED_SYNCHRONIZED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'synchronized' qualifier from " + this.mIsSynchronized + " to " + mInfo.mIsSynchronized);
            consistent = false;
        }
        for (ClassInfo exception : this.thrownExceptions()) {
            if (mInfo.throwsException(exception) || this.name().equals("finalize") && this.mParameters.length <= 0) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " no longer throws exception " + exception.qualifiedName());
            consistent = false;
        }
        for (ClassInfo exec : mInfo.thrownExceptions()) {
            if (this.throwsException(exec) || this.name().equals("finalize") && this.mParameters.length <= 0) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " added thrown exception " + exec.qualifiedName());
            consistent = false;
        }
        return consistent;
    }

    private class APITags
    implements InheritedTags {
        private APITags() {
        }

        @Override
        public TagInfo[] tags() {
            return MethodInfo.this.comment().apiTags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.apiTags();
            }
            return null;
        }
    }

    private class ReturnTags
    implements InheritedTags {
        private ReturnTags() {
        }

        @Override
        public TagInfo[] tags() {
            return MethodInfo.this.comment().returnTags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.returnTags();
            }
            return null;
        }
    }

    private class FirstSentenceTags
    implements InheritedTags {
        private FirstSentenceTags() {
        }

        @Override
        public TagInfo[] tags() {
            return MethodInfo.this.comment().briefTags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.firstSentenceTags();
            }
            return null;
        }
    }

    private class InlineTags
    implements InheritedTags {
        private InlineTags() {
        }

        @Override
        public TagInfo[] tags() {
            return MethodInfo.this.comment().tags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.inlineTags();
            }
            return null;
        }
    }
}

