/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.devkit.doclet.AttributeInfo;
import org.mule.devkit.doclet.Comment;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.FieldInfo;
import org.mule.devkit.doclet.LinkReference;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;

public class AttrTagInfo
extends TagInfo {
    private static final String REF_COMMAND = "ref";
    private static final String NAME_COMMAND = "name";
    private static final String DESCRIPTION_COMMAND = "description";
    private static final Pattern TEXT = Pattern.compile("(\\S+)\\s*(.*)", 32);
    private static final Pattern NAME_TEXT = Pattern.compile("(\\S+)(.*)", 32);
    private ContainerInfo mBase;
    private String mCommand;
    private FieldInfo mRefField;
    private AttributeInfo mAttrInfo;
    private String mAttrName;
    private Comment mDescrComment;

    AttrTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo position) {
        super(name, kind, text, position);
        this.mBase = base;
        this.parse(text, base, position);
    }

    void parse(String text, ContainerInfo base, SourcePositionInfo position) {
        Matcher m = TEXT.matcher(text);
        if (!m.matches()) {
            Errors.error(Errors.BAD_ATTR_TAG, position, "Bad @attr tag: " + text);
            return;
        }
        String command = m.group(1);
        String more = m.group(2);
        if (REF_COMMAND.equals(command)) {
            String ref = more.trim();
            LinkReference linkRef = LinkReference.parse(ref, this.mBase, position, false);
            if (!linkRef.good) {
                Errors.error(Errors.BAD_ATTR_TAG, position, "Unresolved @attr ref: " + ref);
                return;
            }
            if (!(linkRef.memberInfo instanceof FieldInfo)) {
                Errors.error(Errors.BAD_ATTR_TAG, position, "@attr must be a field: " + ref);
                return;
            }
            this.mCommand = command;
            this.mRefField = (FieldInfo)linkRef.memberInfo;
        } else if (NAME_COMMAND.equals(command)) {
            m = NAME_TEXT.matcher(more);
            if (!m.matches() || m.group(2).trim().length() != 0) {
                Errors.error(Errors.BAD_ATTR_TAG, position, "Bad @attr name tag: " + more);
                return;
            }
            this.mCommand = command;
            this.mAttrName = m.group(1);
        } else if (DESCRIPTION_COMMAND.equals(command)) {
            this.mCommand = command;
            this.mDescrComment = new Comment(more, base, position);
        } else {
            Errors.error(Errors.BAD_ATTR_TAG, position, "Bad @attr command: " + command);
        }
    }

    public FieldInfo reference() {
        return REF_COMMAND.equals(this.mCommand) ? this.mRefField : null;
    }

    public String name() {
        return NAME_COMMAND.equals(this.mCommand) ? this.mAttrName : null;
    }

    public Comment description() {
        return DESCRIPTION_COMMAND.equals(this.mCommand) ? this.mDescrComment : null;
    }

    public void makeHDF(Data data, String base) {
        super.makeHDF(data, base);
    }

    public void setAttribute(AttributeInfo info) {
        this.mAttrInfo = info;
    }

    public static void makeReferenceHDF(Data data, String base, AttrTagInfo[] tags) {
        int i = 0;
        for (AttrTagInfo t : tags) {
            if (!REF_COMMAND.equals(t.mCommand)) continue;
            if (t.mAttrInfo == null) {
                String msg = "ERROR: unlinked attr: " + t.mRefField.name();
                throw new RuntimeException(msg);
            }
            data.setValue(base + "." + i + ".name", t.mAttrInfo.name());
            data.setValue(base + "." + i + ".href", t.mAttrInfo.htmlPage());
            ++i;
        }
    }
}

