/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet.apicheck;

import com.sun.javadoc.ClassDoc;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import org.mule.devkit.doclet.AnnotationInstanceInfo;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.ConstructorInfo;
import org.mule.devkit.doclet.Converter;
import org.mule.devkit.doclet.ErrorReport;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.FieldInfo;
import org.mule.devkit.doclet.MethodInfo;
import org.mule.devkit.doclet.PackageInfo;
import org.mule.devkit.doclet.ParameterInfo;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TypeInfo;
import org.mule.devkit.doclet.apicheck.AbstractMethodInfo;
import org.mule.devkit.doclet.apicheck.ApiInfo;
import org.mule.devkit.doclet.apicheck.ApiParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiCheck {
    private static ArrayList<String[]> parseFlags(ArrayList<String> allArgs) {
        String flag;
        int i;
        ArrayList<String[]> ret = new ArrayList<String[]>();
        for (i = 0; i < allArgs.size() && ((flag = allArgs.get(i)).equals("-error") || flag.equals("-warning") || flag.equals("-hide")); ++i) {
            String[] arg = new String[]{flag, allArgs.get(++i)};
            ret.add(arg);
        }
        while (i > 0) {
            allArgs.remove(0);
            --i;
        }
        return ret;
    }

    public static void main(String[] originalArgs) {
        ApiCheck acheck = new ApiCheck();
        ErrorReport report = acheck.checkApi(originalArgs);
        Errors.printErrors(report.getErrors());
        System.exit(report.getCode());
    }

    public ErrorReport checkApi(String[] originalArgs) {
        ApiInfo newApi;
        ApiInfo oldApi;
        ArrayList<String> args = new ArrayList<String>(originalArgs.length);
        for (String a : originalArgs) {
            args.add(a);
        }
        ArrayList<String[]> flags = ApiCheck.parseFlags(args);
        for (String[] a : flags) {
            if (!a[0].equals("-error") && !a[0].equals("-warning") && !a[0].equals("-hide")) continue;
            try {
                int level = -1;
                if (a[0].equals("-error")) {
                    level = Errors.ERROR;
                } else if (a[0].equals("-warning")) {
                    level = Errors.WARNING;
                } else if (a[0].equals("-hide")) {
                    level = Errors.HIDDEN;
                }
                Errors.setErrorLevel(Integer.parseInt(a[1]), level);
            }
            catch (NumberFormatException e) {
                System.err.println("Bad argument: " + a[0] + " " + a[1]);
                return new ErrorReport(2, Errors.getErrors());
            }
        }
        try {
            oldApi = this.parseApi(args.get(0));
            newApi = this.parseApi(args.get(1));
        }
        catch (ApiParseException e) {
            e.printStackTrace();
            System.err.println("Error parsing API");
            return new ErrorReport(3, Errors.getErrors());
        }
        if (!Errors.hadError) {
            oldApi.isConsistent(newApi);
        }
        return new ErrorReport(Errors.hadError ? 1 : 0, Errors.getErrors());
    }

    private InputStream getInputStreamForFile(String filename) throws IOException {
        try {
            URL url = new URL(filename);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(filename);
        }
    }

    public ApiInfo parseApi(String xmlFile) throws ApiParseException {
        InputStream inStream = null;
        try {
            inStream = this.getInputStreamForFile(xmlFile);
            ApiInfo apiInfo = this.parseApi(inStream);
            return apiInfo;
        }
        catch (IOException e) {
            throw new ApiParseException("Error parsing xml: " + xmlFile, e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public ApiInfo parseApi(URL xmlURL) throws ApiParseException {
        InputStream xmlStream = null;
        try {
            xmlStream = xmlURL.openStream();
            ApiInfo apiInfo = this.parseApi(xmlStream);
            return apiInfo;
        }
        catch (IOException e) {
            throw new ApiParseException("Could not open stream for parsing: " + xmlURL, e);
        }
        finally {
            if (xmlStream != null) {
                try {
                    xmlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public ApiInfo parseApi(InputStream xmlStream) throws ApiParseException {
        try {
            XMLReader xmlreader = XMLReaderFactory.createXMLReader();
            MakeHandler handler = new MakeHandler();
            xmlreader.setContentHandler(handler);
            xmlreader.setErrorHandler(handler);
            xmlreader.parse(new InputSource(xmlStream));
            ApiInfo apiInfo = handler.getApi();
            apiInfo.resolveSuperclasses();
            apiInfo.resolveInterfaces();
            return apiInfo;
        }
        catch (Exception e) {
            throw new ApiParseException("Error parsing API", e);
        }
    }

    private class MakeHandler
    extends DefaultHandler {
        private ApiInfo mApi;
        private PackageInfo mCurrentPackage;
        private ClassInfo mCurrentClass;
        private AbstractMethodInfo mCurrentMethod;
        private Stack<ClassInfo> mClassScope = new Stack();

        public MakeHandler() {
            this.mApi = new ApiInfo();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("package")) {
                this.mCurrentPackage = new PackageInfo(attributes.getValue("name"), SourcePositionInfo.fromXml(attributes.getValue("source")));
            } else if (qName.equals("class") || qName.equals("interface")) {
                this.mClassScope.push(this.mCurrentClass);
                ClassDoc classDoc = null;
                String rawCommentText = "";
                SourcePositionInfo position = SourcePositionInfo.fromXml(attributes.getValue("source"));
                String visibility = attributes.getValue("visibility");
                boolean isPublic = "public".equals(visibility);
                boolean isProtected = "protected".equals(visibility);
                boolean isPrivate = "private".equals(visibility);
                boolean isPackagePrivate = !isPublic && !isPrivate && !isProtected;
                boolean isStatic = Boolean.valueOf(attributes.getValue("static"));
                boolean isInterface = qName.equals("interface");
                boolean isAbstract = Boolean.valueOf(attributes.getValue("abstract"));
                boolean isOrdinaryClass = qName.equals("class");
                boolean isException = false;
                boolean isError = false;
                boolean isEnum = false;
                boolean isAnnotation = false;
                boolean isFinal = Boolean.valueOf(attributes.getValue("final"));
                boolean isIncluded = false;
                String name = attributes.getValue("name");
                String qualifiedName = this.qualifiedName(this.mCurrentPackage.name(), name, this.mCurrentClass);
                String qualifiedTypeName = null;
                boolean isPrimitive = false;
                this.mCurrentClass = new ClassInfo(classDoc, rawCommentText, position, isPublic, isProtected, isPackagePrivate, isPrivate, isStatic, isInterface, isAbstract, isOrdinaryClass, isException, isError, isEnum, isAnnotation, isFinal, isIncluded, name, qualifiedName, qualifiedTypeName, isPrimitive);
                this.mCurrentClass.setContainingPackage(this.mCurrentPackage);
                String superclass = attributes.getValue("extends");
                if (superclass == null && !isInterface && !"java.lang.Object".equals(qualifiedName)) {
                    throw new AssertionError((Object)("no superclass known for class " + name));
                }
                this.mApi.mapClassToSuper(this.mCurrentClass, superclass);
                TypeInfo typeInfo = Converter.obtainTypeFromString(qualifiedName);
                this.mCurrentClass.setTypeInfo(typeInfo);
                this.mCurrentClass.setAnnotations(new AnnotationInstanceInfo[0]);
            } else if (qName.equals("method")) {
                String rawCommentText = "";
                TypeInfo[] typeParameters = new TypeInfo[]{};
                String name = attributes.getValue("name");
                String signature = null;
                ClassInfo containingClass = this.mCurrentClass;
                ClassInfo realContainingClass = this.mCurrentClass;
                String visibility = attributes.getValue("visibility");
                boolean isPublic = "public".equals(visibility);
                boolean isProtected = "protected".equals(visibility);
                boolean isPrivate = "private".equals(visibility);
                boolean isPackagePrivate = !isPublic && !isPrivate && !isProtected;
                boolean isFinal = Boolean.valueOf(attributes.getValue("final"));
                boolean isStatic = Boolean.valueOf(attributes.getValue("static"));
                boolean isSynthetic = false;
                boolean isAbstract = Boolean.valueOf(attributes.getValue("abstract"));
                boolean isSynchronized = Boolean.valueOf(attributes.getValue("synchronized"));
                boolean isNative = Boolean.valueOf(attributes.getValue("native"));
                boolean isAnnotationElement = false;
                String kind = qName;
                String flatSignature = null;
                MethodInfo overriddenMethod = null;
                TypeInfo returnType = Converter.obtainTypeFromString(attributes.getValue("return"));
                ParameterInfo[] parameters = new ParameterInfo[]{};
                ClassInfo[] thrownExceptions = new ClassInfo[]{};
                SourcePositionInfo position = SourcePositionInfo.fromXml(attributes.getValue("source"));
                AnnotationInstanceInfo[] annotations = new AnnotationInstanceInfo[]{};
                this.mCurrentMethod = new MethodInfo(rawCommentText, typeParameters, name, signature, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, isFinal, isStatic, isSynthetic, isAbstract, isSynchronized, isNative, isAnnotationElement, kind, flatSignature, overriddenMethod, returnType, parameters, thrownExceptions, position, annotations);
                this.mCurrentMethod.setDeprecated("deprecated".equals(attributes.getValue("deprecated")));
            } else if (qName.equals("constructor")) {
                this.mCurrentMethod = new ConstructorInfo(attributes.getValue("name"), attributes.getValue("type"), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("final")), attributes.getValue("deprecated"), attributes.getValue("visibility"), SourcePositionInfo.fromXml(attributes.getValue("source")), this.mCurrentClass);
            } else if (qName.equals("field")) {
                String visibility = attributes.getValue("visibility");
                boolean isPublic = visibility.equals("public");
                boolean isProtected = visibility.equals("protected");
                boolean isPrivate = visibility.equals("private");
                boolean isPackagePrivate = visibility.equals("");
                String typeName = attributes.getValue("type");
                TypeInfo type = Converter.obtainTypeFromString(typeName);
                FieldInfo fInfo = new FieldInfo(attributes.getValue("name"), this.mCurrentClass, this.mCurrentClass, isPublic, isProtected, isPackagePrivate, isPrivate, Boolean.valueOf(attributes.getValue("final")), Boolean.valueOf(attributes.getValue("static")), Boolean.valueOf(attributes.getValue("transient")), Boolean.valueOf(attributes.getValue("volatile")), false, type, "", attributes.getValue("value"), SourcePositionInfo.fromXml(attributes.getValue("source")), new AnnotationInstanceInfo[0]);
                fInfo.setDeprecated("deprecated".equals(attributes.getValue("deprecated")));
                this.mCurrentClass.addField(fInfo);
            } else if (qName.equals("parameter")) {
                String name = attributes.getValue("name");
                String typeName = attributes.getValue("type");
                TypeInfo type = Converter.obtainTypeFromString(typeName);
                boolean isVarArg = typeName.endsWith("...");
                SourcePositionInfo position = null;
                this.mCurrentMethod.addParameter(new ParameterInfo(name, typeName, type, isVarArg, position));
                this.mCurrentMethod.setVarargs(isVarArg);
            } else if (qName.equals("exception")) {
                this.mCurrentMethod.addException(attributes.getValue("type"));
            } else if (qName.equals("implements")) {
                this.mApi.mapClassToInterface(this.mCurrentClass, attributes.getValue("name"));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("method")) {
                this.mCurrentClass.addMethod((MethodInfo)this.mCurrentMethod);
            } else if (qName.equals("constructor")) {
                this.mCurrentClass.addConstructor((ConstructorInfo)this.mCurrentMethod);
            } else if (qName.equals("class") || qName.equals("interface")) {
                this.mCurrentPackage.addClass(this.mCurrentClass);
                this.mCurrentClass = this.mClassScope.pop();
            } else if (qName.equals("package")) {
                this.mApi.addPackage(this.mCurrentPackage);
            }
        }

        public ApiInfo getApi() {
            return this.mApi;
        }

        private String qualifiedName(String pkg, String className, ClassInfo parent) {
            String parentQName = parent != null ? parent.qualifiedName() + "." : "";
            return pkg + "." + parentQName + className;
        }
    }
}

