/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.LinkReference;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;

public class SeeTagInfo
extends TagInfo {
    private ContainerInfo mBase;
    LinkReference mLink;

    SeeTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo position) {
        super(name, kind, text, position);
        this.mBase = base;
    }

    protected LinkReference linkReference() {
        if (this.mLink == null) {
            this.mLink = LinkReference.parse(this.text(), this.mBase, this.position(), !"@see".equals(this.name()) && (this.mBase == null || this.mBase.checkLevel()));
        }
        return this.mLink;
    }

    public String label() {
        return this.linkReference().label;
    }

    public void makeHDF(Data data, String base) {
        LinkReference linkRef = this.linkReference();
        if (linkRef.kind != null) {
            this.setKind(linkRef.kind);
        }
        super.makeHDF(data, base);
        data.setValue(base + ".label", linkRef.label);
        if (linkRef.href != null) {
            data.setValue(base + ".href", linkRef.href);
            if (linkRef.isLocal) {
                data.setValue(base + ".isLocal", "1");
            }
        }
    }

    public boolean checkLevel() {
        return this.linkReference().checkLevel();
    }

    public static void makeHDF(Data data, String base, SeeTagInfo[] tags) {
        int j = 0;
        for (SeeTagInfo tag : tags) {
            if (!tag.mBase.checkLevel() || !tag.checkLevel()) continue;
            tag.makeHDF(data, base + "." + j);
            ++j;
        }
    }
}

