/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.devkit.doclet.Comment;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.FederatedSite;
import org.mule.devkit.doclet.SourcePositionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocInfo {
    private String mRawCommentText;
    Comment mComment;
    SourcePositionInfo mPosition;
    private String mSince;
    private Set<FederatedSite> mFederatedReferences = new LinkedHashSet<FederatedSite>();

    public DocInfo(String rawCommentText, SourcePositionInfo sp) {
        this.mRawCommentText = rawCommentText;
        this.mPosition = sp;
    }

    public abstract boolean isDefinedLocally();

    public abstract String relativePath();

    public final String htmlPage() {
        if (this.isDefinedLocally()) {
            return this.relativePath();
        }
        Set<FederatedSite> sites = this.getFederatedReferences();
        if (!sites.isEmpty()) {
            return sites.iterator().next().linkFor(this.relativePath());
        }
        return null;
    }

    public boolean isHidden() {
        return this.comment().isHidden();
    }

    public boolean isDocOnly() {
        return this.comment().isDocOnly();
    }

    public String getRawCommentText() {
        return this.mRawCommentText;
    }

    public Comment comment() {
        if (this.mComment == null) {
            this.mComment = new Comment(this.mRawCommentText, this.parent(), this.mPosition);
        }
        return this.mComment;
    }

    public SourcePositionInfo position() {
        return this.mPosition;
    }

    public abstract ContainerInfo parent();

    public void setSince(String since) {
        this.mSince = since;
    }

    public String getSince() {
        return this.mSince;
    }

    public final void addFederatedReference(FederatedSite source) {
        this.mFederatedReferences.add(source);
    }

    public final Set<FederatedSite> getFederatedReferences() {
        return this.mFederatedReferences;
    }

    public final void setFederatedReferences(Data data, String base) {
        int pos = 0;
        for (FederatedSite source : this.getFederatedReferences()) {
            data.setValue(base + ".federated." + pos + ".url", source.linkFor(this.relativePath()));
            data.setValue(base + ".federated." + pos + ".name", source.name());
            ++pos;
        }
    }
}

