<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= CONNECTION MANAGEMENT DETAIL ======== -->
<h2>Connection Pool</h2>
<p>This connector offers automatic connection management via the use of a connection pool. The pool will act a storage mechanism for all the connections that are in-use by the user of
this connector.</p>
<p>Prior to execution of a processor, the connector will attempt to lookup an already established connection and if one doesn't exists it will
create one. That lookup mechanism is done in the connection pool via the use of connection variables declared as keys.</p>
<p>The user of the connector can configure the pool by adding a <code>connection-pooling-profile</code> to the connector configuration like this:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:connection-pooling-profile maxActive="10" maxIdle="10"
                             exhaustedAction="WHEN_EXHAUSTED_GROW" maxWait="120"/&gt;
</pre>
<p>The following is a list of connection attributes, each connection attribute can be configured at the config element level or
they can also be added to each processor. If they are used at the processor level they get the benefit of full expression
resolution.</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">Connection Attributes</th></tr>
<tr><th>Name</th><th>Default Value</th><th>Description</th><th>Java Type</th><th>MIME Type</th><th>Encoding</th></tr>
<tr><td class="jd-linkcol"><nobr>config-ref</nobr></td>
<td class="jd-descrcol"></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Specify which configuration to use.</td><td/><td/><td/></tr>
<?cs set:count = #2 ?>
    <?cs each:connectionAttribute=class.moduleConnectVariables ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr><?cs var:connectionAttribute.name ?></nobr></td>
          <td class="jd-descrcol"><nobr><?cs var:connectionAttribute.defaultValue ?></nobr></td>
          <td class="jd-descrcol" width="100%"><?cs if:connectionAttribute.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:op_tag_list(connectionAttribute.comment) ?></td>
          <td class="jd-descrcol"><?cs if:connectionAttribute.useLinkForClass=="true" ?><?cs call:type_link(connectionAttribute.type)?><?cs else ?><?cs var:connectionAttribute.label ?><?cs /if ?></td>
          <td class="jd-descrcol"><?cs var:connectionAttribute.mimeType ?></td>
          <td class="jd-descrcol"><?cs var:connectionAttribute.encoding ?></td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /each ?>
</table>
<h2>Reconnection Strategies</h2>
<p>Reconnection Strategies specify how a connector behaves when its connection fails. You can control how Mule attempts to reconnect by specifying a number of criteria:</p>
<ul>
<li>The type of exception</li>
<li>Number and frequency of reconnection attempts</li>
<li>The notifications generated, and more</li>
</ul>
<p>With a reconnection strategy, you can better control the behavior of a failed connection, by configuring it, for example,
to re-attempt the connection only once every 15 minutes, and to give up after 30 attempts. You can also send an automatic
notification to your IT administrator whenever this reconnection strategy goes into effect. You can even define a strategy that
attempts to reconnect only during business hours. Such a setting can prove useful if your server is frequently shut down for
 nightly maintenance.</p>
<h3>Configuration</h3>
<p>A reconnection strategy that allows the user to configure how many times a reconnection should be attempted and how long to wait between attempts.</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:<?cs var:class.moduleConfigElementName ?>&gt;
         &lt;reconnect count="5" frequency="1000"/&gt;
    &lt;/<?cs var:class.moduleName ?>:<?cs var:class.moduleConfigElementName ?>&gt;
</pre>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">Reconnect Attributes</th></tr>
<tr><th>Name</th><th>Default Value</th><th>Description</th></tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>frequency</nobr></td>
<td class="jd-descrcol"><nobr>2000</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>How often (in ms) to reconnect</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>count</nobr></td>
<td class="jd-descrcol"><nobr>2</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>How many reconnection attempts to make</td>
</tr>
</table>
<p>For more information about reconnection strategies in Mule, or even how to write your own custom reconnection strategy please check <a href="http://www.mulesoft.org/documentation/display/MULE3USER/Configuring+Reconnection+Strategies">this</a> section.</p>
