/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.Arrays;
import java.util.TreeMap;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.ClearPage;
import org.mule.devkit.doclet.Converter;
import org.mule.devkit.doclet.DocInfo;
import org.mule.devkit.doclet.Doclava;
import org.mule.devkit.doclet.FieldInfo;
import org.mule.devkit.doclet.InheritedTags;
import org.mule.devkit.doclet.MemberInfo;
import org.mule.devkit.doclet.MethodInfo;
import org.mule.devkit.doclet.PackageInfo;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;

public class TodoFile {
    public static final String MISSING = "No description text";

    public static boolean areTagsUseful(InheritedTags tags) {
        while (tags != null) {
            if (TodoFile.areTagsUseful(tags.tags())) {
                return true;
            }
            tags = tags.inherited();
        }
        return false;
    }

    public static boolean areTagsUseful(TagInfo[] tags) {
        for (TagInfo t : tags) {
            if ("Text".equals(t.name()) && t.text().trim().length() != 0) {
                return true;
            }
            if (!"@inheritDoc".equals(t.name())) continue;
            return true;
        }
        return false;
    }

    public static void setHDF(Data data, String base, SourcePositionInfo pos, String name, String descr) {
        data.setValue(base + ".pos", pos.toString());
        data.setValue(base + ".name", name);
        data.setValue(base + ".descr", descr);
    }

    public static String percent(int a, int b) {
        return "" + Math.round((float)(b - a) / (float)b * 100.0f) + "%";
    }

    public static void writeTodoFile(String filename) {
        Data data = Doclava.makeHDF();
        Doclava.setPageTitle(data, "Missing Documentation");
        TreeMap<String, PackageStats> packageStats = new TreeMap<String, PackageStats>();
        Object[] classes = Converter.rootClasses();
        Arrays.sort(classes);
        int classIndex = 0;
        for (Object cl : classes) {
            PackageInfo pkg;
            String pkgName;
            PackageStats ps;
            boolean good;
            if (((ClassInfo)cl).isHidden()) continue;
            String classBase = "classes." + classIndex;
            String base = classBase + ".errors.";
            int errors = 0;
            int total = 1;
            if (!TodoFile.areTagsUseful(((ClassInfo)cl).inlineTags())) {
                TodoFile.setHDF(data, base + errors, ((DocInfo)cl).position(), "&lt;class comment&gt;", MISSING);
                ++errors;
            }
            for (MethodInfo methodInfo : ((ClassInfo)cl).constructors()) {
                good = true;
                ++total;
                if (methodInfo.checkLevel() && !TodoFile.areTagsUseful(methodInfo.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, methodInfo.position(), methodInfo.prettySignature(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (MethodInfo methodInfo : ((ClassInfo)cl).selfMethods()) {
                good = true;
                ++total;
                if (methodInfo.checkLevel() && !TodoFile.areTagsUseful(methodInfo.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, methodInfo.position(), methodInfo.name() + methodInfo.prettySignature(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (MemberInfo memberInfo : ((ClassInfo)cl).enumConstants()) {
                good = true;
                ++total;
                if (memberInfo.checkLevel() && !TodoFile.areTagsUseful(((FieldInfo)memberInfo).inlineTags())) {
                    TodoFile.setHDF(data, base + errors, memberInfo.position(), memberInfo.name(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (MemberInfo memberInfo : ((ClassInfo)cl).selfFields()) {
                good = true;
                ++total;
                if (memberInfo.checkLevel() && !TodoFile.areTagsUseful(((FieldInfo)memberInfo).inlineTags())) {
                    TodoFile.setHDF(data, base + errors, memberInfo.position(), memberInfo.name(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            if (errors > 0) {
                data.setValue(classBase + ".qualified", ((ClassInfo)cl).qualifiedName());
                data.setValue(classBase + ".errorCount", "" + errors);
                data.setValue(classBase + ".totalCount", "" + total);
                data.setValue(classBase + ".percentGood", TodoFile.percent(errors, total));
            }
            if ((ps = (PackageStats)packageStats.get(pkgName = (pkg = ((ClassInfo)cl).containingPackage()) != null ? pkg.name() : "")) == null) {
                ps = new PackageStats();
                ps.name = pkgName;
                packageStats.put(pkgName, ps);
            }
            ps.total += total;
            ps.errors += errors;
            ++classIndex;
        }
        int allTotal = 0;
        int allErrors = 0;
        int i = 0;
        for (PackageStats ps : packageStats.values()) {
            data.setValue("packages." + i + ".name", "" + ps.name);
            data.setValue("packages." + i + ".errorCount", "" + ps.errors);
            data.setValue("packages." + i + ".totalCount", "" + ps.total);
            data.setValue("packages." + i + ".percentGood", TodoFile.percent(ps.errors, ps.total));
            allTotal += ps.total;
            allErrors += ps.errors;
            ++i;
        }
        data.setValue("all.errorCount", "" + allErrors);
        data.setValue("all.totalCount", "" + allTotal);
        data.setValue("all.percentGood", TodoFile.percent(allErrors, allTotal));
        ClearPage.write(data, "todo.cs", filename, true);
    }

    static class PackageStats {
        String name;
        public int total;
        public int errors;

        PackageStats() {
        }
    }
}

