/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.mule.devkit.doclet.AnnotationInstanceInfo;
import org.mule.devkit.doclet.AnnotationValueInfo;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.FieldInfo;
import org.mule.devkit.doclet.MethodInfo;
import org.mule.devkit.doclet.PackageInfo;
import org.mule.devkit.doclet.ParamTagInfo;
import org.mule.devkit.doclet.ParameterInfo;
import org.mule.devkit.doclet.SeeTagInfo;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.TextTagInfo;
import org.mule.devkit.doclet.ThrowsTagInfo;
import org.mule.devkit.doclet.TypeInfo;

public class Converter {
    private static RootDoc root;
    private static ClassInfo[] mRootClasses;
    private static ArrayList<ClassNeedingInit> mClassesNeedingInit;
    private static Cache<ClassDoc, ClassInfo> mClasses;
    private static Cache<ExecutableMemberDoc, MethodInfo> mMethods;
    private static Cache<FieldDoc, FieldInfo> mFields;
    private static Cache<PackageDoc, PackageInfo> mPackages;
    private static Cache<Type, TypeInfo> mTypes;
    private static final Cache<String, TypeInfo> mTypesFromString;
    private static Cache<AnnotationDesc, AnnotationInstanceInfo> mAnnotationInstances;
    private static HashMap<AnnotationValue, AnnotationValueInfo> mAnnotationValues;
    private static HashSet<AnnotationValue> mAnnotationValuesNeedingInit;

    public static void makeInfo(RootDoc r) {
        int i;
        root = r;
        ClassDoc[] classDocs = r.classes();
        int N = classDocs.length;
        for (i = 0; i < N; ++i) {
            Converter.obtainClass(classDocs[i]);
        }
        ArrayList<ClassInfo> classesNeedingInit2 = new ArrayList<ClassInfo>();
        while (mClassesNeedingInit.size() > 0) {
            i = mClassesNeedingInit.size() - 1;
            ClassNeedingInit clni = mClassesNeedingInit.get(i);
            mClassesNeedingInit.remove(i);
            Converter.initClass(clni.c, clni.cl);
            classesNeedingInit2.add(clni.cl);
        }
        mClassesNeedingInit = null;
        for (ClassInfo cl : classesNeedingInit2) {
            cl.init2();
        }
        Converter.finishAnnotationValueInit();
        mRootClasses = Converter.convertClasses(r.classes());
    }

    public static ClassInfo[] rootClasses() {
        return mRootClasses;
    }

    public static ClassInfo[] allClasses() {
        return (ClassInfo[])mClasses.all();
    }

    private static void initClass(ClassDoc c, ClassInfo cl) {
        Object[] annotationElements = c instanceof AnnotationTypeDoc ? ((AnnotationTypeDoc)c).elements() : new MethodDoc[]{};
        cl.init(Converter.obtainType((Type)c), Converter.convertClasses(c.interfaces()), Converter.convertTypes(c.interfaceTypes()), Converter.convertClasses(c.innerClasses()), Converter.convertMethods(c.constructors(false)), Converter.convertMethods(c.methods(false)), Converter.convertMethods(annotationElements), Converter.convertFields(c.fields(false)), Converter.convertFields(c.enumConstants()), Converter.obtainPackage(c.containingPackage()), Converter.obtainClass(c.containingClass()), Converter.obtainClass(c.superclass()), Converter.obtainType(c.superclassType()), Converter.convertAnnotationInstances(c.annotations()));
        cl.setHiddenMethods(Converter.getHiddenMethods(c.methods(false)));
        cl.setNonWrittenConstructors(Converter.convertNonWrittenConstructors(c.constructors(false)));
        cl.init3(Converter.convertTypes((Type[])c.typeParameters()), Converter.convertClasses(c.innerClasses(false)));
    }

    public static ClassInfo obtainClass(String className) {
        return Converter.obtainClass(root.classNamed(className));
    }

    public static PackageInfo obtainPackage(String packageName) {
        return Converter.obtainPackage(root.packageNamed(packageName));
    }

    private static TagInfo convertTag(Tag tag) {
        return new TextTagInfo(tag.name(), tag.kind(), tag.text(), Converter.convertSourcePosition(tag.position()));
    }

    private static ThrowsTagInfo convertThrowsTag(ThrowsTag tag, ContainerInfo base) {
        return new ThrowsTagInfo(tag.name(), tag.text(), tag.kind(), Converter.obtainClass(tag.exception()), tag.exceptionComment(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static ParamTagInfo convertParamTag(ParamTag tag, ContainerInfo base) {
        return new ParamTagInfo(tag.name(), tag.kind(), tag.text(), tag.isTypeParameter(), tag.parameterComment(), tag.parameterName(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static SeeTagInfo convertSeeTag(SeeTag tag, ContainerInfo base) {
        return new SeeTagInfo(tag.name(), tag.kind(), tag.text(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static SourcePositionInfo convertSourcePosition(SourcePosition sp) {
        if (sp == null) {
            return null;
        }
        return new SourcePositionInfo(sp.file().toString(), sp.line(), sp.column());
    }

    public static TagInfo[] convertTags(Tag[] tags, ContainerInfo base) {
        int len = tags.length;
        TagInfo[] out = new TagInfo[len];
        for (int i = 0; i < len; ++i) {
            Tag t = tags[i];
            out[i] = t instanceof SeeTag ? Converter.convertSeeTag((SeeTag)t, base) : (t instanceof ThrowsTag ? Converter.convertThrowsTag((ThrowsTag)t, base) : (t instanceof ParamTag ? Converter.convertParamTag((ParamTag)t, base) : Converter.convertTag(t)));
        }
        return out;
    }

    public static ClassInfo[] convertClasses(ClassDoc[] classes) {
        if (classes == null) {
            return null;
        }
        int N = classes.length;
        ClassInfo[] result = new ClassInfo[N];
        for (int i = 0; i < N; ++i) {
            result[i] = Converter.obtainClass(classes[i]);
        }
        return result;
    }

    private static ParameterInfo convertParameter(Parameter p, SourcePosition pos, boolean isVarArg) {
        if (p == null) {
            return null;
        }
        ParameterInfo pi = new ParameterInfo(p.name(), p.typeName(), Converter.obtainType(p.type()), isVarArg, Converter.convertSourcePosition(pos), Converter.convertAnnotationInstances(p.annotations()));
        return pi;
    }

    private static ParameterInfo[] convertParameters(Parameter[] p, ExecutableMemberDoc m) {
        SourcePosition pos = m.position();
        int len = p.length;
        ParameterInfo[] q = new ParameterInfo[len];
        for (int i = 0; i < len; ++i) {
            boolean isVarArg = m.isVarArgs() && i == len - 1;
            q[i] = Converter.convertParameter(p[i], pos, isVarArg);
        }
        return q;
    }

    private static TypeInfo[] convertTypes(Type[] p) {
        if (p == null) {
            return null;
        }
        int len = p.length;
        TypeInfo[] q = new TypeInfo[len];
        for (int i = 0; i < len; ++i) {
            q[i] = Converter.obtainType(p[i]);
        }
        return q;
    }

    private Converter() {
    }

    static ClassInfo obtainClass(ClassDoc o) {
        return mClasses.obtain(o);
    }

    private static MethodInfo[] getHiddenMethods(MethodDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.isHidden()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertMethods(MethodDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertMethods(ConstructorDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertNonWrittenConstructors(ConstructorDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo obtainMethod(MethodDoc o) {
        return mMethods.obtain((ExecutableMemberDoc)o);
    }

    private static MethodInfo obtainMethod(ConstructorDoc o) {
        return mMethods.obtain((ExecutableMemberDoc)o);
    }

    private static FieldInfo[] convertFields(FieldDoc[] fields) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldInfo> out = new ArrayList<FieldInfo>();
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            FieldInfo f = Converter.obtainField(fields[i]);
            out.add(f);
        }
        return out.toArray(new FieldInfo[out.size()]);
    }

    private static FieldInfo obtainField(FieldDoc o) {
        return mFields.obtain(o);
    }

    private static PackageInfo obtainPackage(PackageDoc o) {
        return mPackages.obtain(o);
    }

    private static TypeInfo obtainType(Type o) {
        return mTypes.obtain(o);
    }

    public static TypeInfo obtainTypeFromString(String type) {
        return mTypesFromString.obtain(type);
    }

    private static AnnotationInstanceInfo[] convertAnnotationInstances(AnnotationDesc[] orig) {
        int len = orig.length;
        AnnotationInstanceInfo[] out = new AnnotationInstanceInfo[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Converter.obtainAnnotationInstance(orig[i]);
        }
        return out;
    }

    private static AnnotationInstanceInfo obtainAnnotationInstance(AnnotationDesc o) {
        return mAnnotationInstances.obtain(o);
    }

    private static AnnotationValueInfo obtainAnnotationValue(AnnotationValue o, MethodInfo element) {
        if (o == null) {
            return null;
        }
        AnnotationValueInfo v = mAnnotationValues.get(o);
        if (v != null) {
            return v;
        }
        v = new AnnotationValueInfo(element);
        mAnnotationValues.put(o, v);
        if (mAnnotationValuesNeedingInit != null) {
            mAnnotationValuesNeedingInit.add(o);
        } else {
            Converter.initAnnotationValue(o, v);
        }
        return v;
    }

    private static void initAnnotationValue(AnnotationValue o, AnnotationValueInfo v) {
        AnnotationValueInfo[] converted;
        Object orig = o.value();
        if (orig instanceof Type) {
            converted = Converter.obtainType((Type)orig);
        } else if (orig instanceof FieldDoc) {
            converted = Converter.obtainField((FieldDoc)orig);
        } else if (orig instanceof AnnotationDesc) {
            converted = Converter.obtainAnnotationInstance((AnnotationDesc)orig);
        } else if (orig instanceof AnnotationValue[]) {
            AnnotationValue[] old = (AnnotationValue[])orig;
            AnnotationValueInfo[] array = new AnnotationValueInfo[old.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Converter.obtainAnnotationValue(old[i], null);
            }
            converted = array;
        } else {
            converted = orig;
        }
        v.init(converted);
    }

    private static void finishAnnotationValueInit() {
        while (mAnnotationValuesNeedingInit.size() > 0) {
            HashSet<AnnotationValue> set = mAnnotationValuesNeedingInit;
            mAnnotationValuesNeedingInit = new HashSet();
            for (AnnotationValue o : set) {
                AnnotationValueInfo v = mAnnotationValues.get(o);
                Converter.initAnnotationValue(o, v);
            }
        }
        mAnnotationValuesNeedingInit = null;
    }

    static {
        mClassesNeedingInit = new ArrayList();
        mClasses = new Cache<ClassDoc, ClassInfo>(){

            @Override
            protected ClassInfo make(ClassDoc input) {
                if (input.name() == null || input.name().equals("")) {
                    return null;
                }
                try {
                    ClassInfo cl = new ClassInfo(input, input.getRawCommentText(), Converter.convertSourcePosition(input.position()), input.isPublic(), input.isProtected(), input.isPackagePrivate(), input.isPrivate(), input.isStatic(), input.isInterface(), input.isAbstract(), input.isOrdinaryClass(), input.isException(), input.isError(), input.isEnum(), input instanceof AnnotationTypeDoc, input.isFinal(), input.isIncluded(), input.name(), input.qualifiedName(), input.qualifiedTypeName(), input.isPrimitive());
                    if (mClassesNeedingInit != null) {
                        mClassesNeedingInit.add(new ClassNeedingInit(input, cl));
                    }
                    return cl;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            protected void made(ClassDoc input, ClassInfo output) {
                if (mClassesNeedingInit == null) {
                    Converter.initClass(input, output);
                    output.init2();
                }
            }

            ClassInfo[] all() {
                return this.mCache.values().toArray(new ClassInfo[this.mCache.size()]);
            }
        };
        mMethods = new Cache<ExecutableMemberDoc, MethodInfo>(){

            @Override
            protected MethodInfo make(ExecutableMemberDoc o) {
                if (o instanceof AnnotationTypeElementDoc) {
                    AnnotationTypeElementDoc m = (AnnotationTypeElementDoc)o;
                    MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), m.isAbstract(), m.isSynchronized(), m.isNative(), true, "annotationElement", m.flatSignature(), Converter.obtainMethod(m.overriddenMethod()), Converter.obtainType(m.returnType()), Converter.convertParameters(m.parameters(), (ExecutableMemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                    result.setVarargs(m.isVarArgs());
                    result.init(Converter.obtainAnnotationValue(m.defaultValue(), result));
                    return result;
                }
                if (o instanceof MethodDoc) {
                    MethodDoc m = (MethodDoc)o;
                    MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), m.isAbstract(), m.isSynchronized(), m.isNative(), false, "method", m.flatSignature(), Converter.obtainMethod(m.overriddenMethod()), Converter.obtainType(m.returnType()), Converter.convertParameters(m.parameters(), (ExecutableMemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                    result.setVarargs(m.isVarArgs());
                    result.init(null);
                    return result;
                }
                ConstructorDoc m = (ConstructorDoc)o;
                MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), false, m.isSynchronized(), m.isNative(), false, "constructor", m.flatSignature(), null, null, Converter.convertParameters(m.parameters(), (ExecutableMemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                result.setVarargs(m.isVarArgs());
                result.init(null);
                return result;
            }
        };
        mFields = new Cache<FieldDoc, FieldInfo>(){

            @Override
            protected FieldInfo make(FieldDoc f) {
                return new FieldInfo(f.name(), Converter.obtainClass(f.containingClass()), Converter.obtainClass(f.containingClass()), f.isPublic(), f.isProtected(), f.isPackagePrivate(), f.isPrivate(), f.isFinal(), f.isStatic(), f.isTransient(), f.isVolatile(), f.isSynthetic(), Converter.obtainType(f.type()), f.getRawCommentText(), f.constantValue(), Converter.convertSourcePosition(f.position()), Converter.convertAnnotationInstances(f.annotations()));
            }
        };
        mPackages = new Cache<PackageDoc, PackageInfo>(){

            @Override
            protected PackageInfo make(PackageDoc p) {
                return new PackageInfo(p, p.name(), Converter.convertSourcePosition(p.position()));
            }
        };
        mTypes = new Cache<Type, TypeInfo>(){

            @Override
            protected TypeInfo make(Type t) {
                String simpleTypeName = t instanceof ClassDoc ? ((ClassDoc)t).name() : t.simpleTypeName();
                TypeInfo ti = new TypeInfo(t.isPrimitive(), t.dimension(), simpleTypeName, t.qualifiedTypeName(), Converter.obtainClass(t.asClassDoc()));
                return ti;
            }

            @Override
            protected void made(Type t, TypeInfo ti) {
                if (t.asParameterizedType() != null) {
                    ti.setTypeArguments(Converter.convertTypes(t.asParameterizedType().typeArguments()));
                } else if (t instanceof ClassDoc) {
                    ti.setTypeArguments(Converter.convertTypes((Type[])((ClassDoc)t).typeParameters()));
                } else if (t.asTypeVariable() != null) {
                    ti.setBounds(null, Converter.convertTypes(t.asTypeVariable().bounds()));
                    ti.setIsTypeVariable(true);
                } else if (t.asWildcardType() != null) {
                    ti.setIsWildcard(true);
                    ti.setBounds(Converter.convertTypes(t.asWildcardType().superBounds()), Converter.convertTypes(t.asWildcardType().extendsBounds()));
                }
            }

            @Override
            protected Object keyFor(Type t) {
                StringBuilder result = new StringBuilder();
                result.append(t.getClass().getName()).append("/").append(t).append("/");
                if (t.asParameterizedType() != null) {
                    result.append(t.asParameterizedType()).append("/");
                    if (t.asParameterizedType().typeArguments() != null) {
                        for (Type ty : t.asParameterizedType().typeArguments()) {
                            result.append(ty).append("/");
                        }
                    }
                } else {
                    result.append("NoParameterizedType//");
                }
                if (t.asTypeVariable() != null) {
                    result.append(t.asTypeVariable()).append("/");
                    if (t.asTypeVariable().bounds() != null) {
                        for (Type ty : t.asTypeVariable().bounds()) {
                            result.append(ty).append("/");
                        }
                    }
                } else {
                    result.append("NoTypeVariable//");
                }
                if (t.asWildcardType() != null) {
                    result.append(t.asWildcardType()).append("/");
                    if (t.asWildcardType().superBounds() != null) {
                        for (Type ty : t.asWildcardType().superBounds()) {
                            result.append(ty).append("/");
                        }
                    }
                    if (t.asWildcardType().extendsBounds() != null) {
                        for (Type ty : t.asWildcardType().extendsBounds()) {
                            result.append(ty).append("/");
                        }
                    }
                } else {
                    result.append("NoWildCardType//");
                }
                return result.toString();
            }
        };
        mTypesFromString = new Cache<String, TypeInfo>(){

            @Override
            protected TypeInfo make(String name) {
                return new TypeInfo(name);
            }
        };
        mAnnotationInstances = new Cache<AnnotationDesc, AnnotationInstanceInfo>(){

            @Override
            protected AnnotationInstanceInfo make(AnnotationDesc a) {
                ClassInfo annotationType;
                try {
                    annotationType = Converter.obtainClass((ClassDoc)a.annotationType());
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Could not find annotation " + a.toString() + " on classpath.", e);
                }
                AnnotationDesc.ElementValuePair[] ev = a.elementValues();
                AnnotationValueInfo[] elementValues = new AnnotationValueInfo[ev.length];
                for (int i = 0; i < ev.length; ++i) {
                    elementValues[i] = Converter.obtainAnnotationValue(ev[i].value(), Converter.obtainMethod((MethodDoc)ev[i].element()));
                }
                return new AnnotationInstanceInfo(annotationType, elementValues);
            }
        };
        mAnnotationValues = new HashMap();
        mAnnotationValuesNeedingInit = new HashSet();
    }

    private static abstract class Cache<K, V> {
        protected final HashMap<Object, V> mCache = new HashMap();

        private Cache() {
        }

        V obtain(K input) {
            if (input == null) {
                return null;
            }
            Object key = this.keyFor(input);
            V value = this.mCache.get(key);
            if (value == null && (value = this.make(input)) != null) {
                this.mCache.put(key, value);
                this.made(input, value);
            }
            return value;
        }

        protected abstract V make(K var1);

        protected void made(K input, V value) {
        }

        protected Object keyFor(K key) {
            return key;
        }

        Object[] all() {
            return null;
        }
    }

    private static class ClassNeedingInit {
        ClassDoc c;
        ClassInfo cl;

        ClassNeedingInit(ClassDoc c, ClassInfo cl) {
            this.c = c;
            this.cl = cl;
        }
    }
}

