/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet.apicheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.PackageInfo;

public class ApiInfo {
    private HashMap<String, PackageInfo> mPackages = new HashMap();
    private HashMap<String, ClassInfo> mAllClasses = new HashMap();
    private Map<ClassInfo, String> mClassToSuper = new HashMap<ClassInfo, String>();
    private Map<ClassInfo, ArrayList<String>> mClassToInterface = new HashMap<ClassInfo, ArrayList<String>>();

    public ClassInfo findClass(String name) {
        return this.mAllClasses.get(name);
    }

    protected void resolveInterfaces() {
        for (ClassInfo cl : this.mAllClasses.values()) {
            ArrayList<String> ifaces = this.mClassToInterface.get(cl);
            if (ifaces == null) continue;
            for (String iface : ifaces) {
                cl.addInterface(this.mAllClasses.get(iface));
            }
        }
    }

    public boolean isConsistent(ApiInfo newApi) {
        boolean consistent = true;
        for (PackageInfo pInfo : this.mPackages.values()) {
            if (newApi.getPackages().containsKey(pInfo.name())) {
                if (pInfo.isConsistent(newApi.getPackages().get(pInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_PACKAGE, pInfo.position(), "Removed package " + pInfo.name());
            consistent = false;
        }
        for (PackageInfo pInfo : newApi.mPackages.values()) {
            if (this.mPackages.containsKey(pInfo.name())) continue;
            Errors.error(Errors.ADDED_PACKAGE, pInfo.position(), "Added package " + pInfo.name());
            consistent = false;
        }
        return consistent;
    }

    public HashMap<String, PackageInfo> getPackages() {
        return this.mPackages;
    }

    protected void mapClassToSuper(ClassInfo classInfo, String superclass) {
        this.mClassToSuper.put(classInfo, superclass);
    }

    protected void mapClassToInterface(ClassInfo classInfo, String iface) {
        if (!this.mClassToInterface.containsKey(classInfo)) {
            this.mClassToInterface.put(classInfo, new ArrayList());
        }
        this.mClassToInterface.get(classInfo).add(iface);
    }

    protected void addPackage(PackageInfo pInfo) {
        this.mPackages.put(pInfo.name(), pInfo);
        for (ClassInfo cl : pInfo.allClasses().values()) {
            this.mAllClasses.put(cl.qualifiedName(), cl);
        }
    }

    protected void resolveSuperclasses() {
        for (ClassInfo cl : this.mAllClasses.values()) {
            ClassInfo superclass;
            if (cl.qualifiedName().equals("java.lang.Object")) continue;
            String scName = this.mClassToSuper.get(cl);
            if (scName == null) {
                scName = "java.lang.Object";
            }
            if ((superclass = this.mAllClasses.get(scName)) == null) {
                superclass = new ClassInfo(scName);
            }
            cl.setSuperClass(superclass);
        }
    }
}

