/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.devkit.doclet.AttrTagInfo;
import org.mule.devkit.doclet.CodeTagInfo;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.Doclava;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.LiteralTagInfo;
import org.mule.devkit.doclet.ParamTagInfo;
import org.mule.devkit.doclet.ParsedTagInfo;
import org.mule.devkit.doclet.SampleTagInfo;
import org.mule.devkit.doclet.SeeTagInfo;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.TextTagInfo;
import org.mule.devkit.doclet.ThrowsTagInfo;

public class Comment {
    static final Pattern LEADING_WHITESPACE = Pattern.compile("^[ \t\n\r]*(.*)$", 32);
    static final Pattern TAG_BEGIN = Pattern.compile("[\r\n][\r\n \t]*@", 32);
    static final Pattern TAG = Pattern.compile("(@[^ \t\r\n]+)[ \t\r\n]+(.*)", 32);
    static final Pattern INLINE_TAG = Pattern.compile("(.*?)\\{(@[^ \t\r\n\\}]+)[ \t\r\n]*(.*?)\\}", 32);
    static final Pattern FIRST_SENTENCE = Pattern.compile("((.*?)\\.)[ \t\r\n\\<](.*)", 32);
    private static final String[] KNOWN_TAGS = new String[]{"@author", "@since", "@version", "@deprecated", "@undeprecate", "@docRoot", "@sdkCurrent", "@inheritDoc", "@more", "@sample", "@include", "@serial"};
    boolean mInitialized;
    int mHidden = -1;
    int mDocOnly = -1;
    int mDeprecated = -1;
    String mText;
    ContainerInfo mBase;
    SourcePositionInfo mPosition;
    int mLine = 1;
    TagInfo[] mInlineTags;
    TagInfo[] mTags;
    ParamTagInfo[] mParamTags;
    SeeTagInfo[] mSeeTags;
    ThrowsTagInfo[] mThrowsTags;
    TagInfo[] mBriefTags;
    TagInfo[] mReturnTags;
    TagInfo[] mDeprecatedTags;
    TagInfo[] mUndeprecateTags;
    AttrTagInfo[] mAttrTags;
    ArrayList<TagInfo> mInlineTagsList = new ArrayList();
    ArrayList<TagInfo> mTagsList = new ArrayList();
    ArrayList<ParamTagInfo> mParamTagsList = new ArrayList();
    ArrayList<SeeTagInfo> mSeeTagsList = new ArrayList();
    ArrayList<ThrowsTagInfo> mThrowsTagsList = new ArrayList();
    ArrayList<TagInfo> mBriefTagsList = new ArrayList();
    ArrayList<ParsedTagInfo> mReturnTagsList = new ArrayList();
    ArrayList<ParsedTagInfo> mDeprecatedTagsList = new ArrayList();
    ArrayList<TagInfo> mUndeprecateTagsList = new ArrayList();
    ArrayList<AttrTagInfo> mAttrTagsList = new ArrayList();

    public Comment(String text, ContainerInfo base, SourcePositionInfo sp) {
        this.mText = text;
        this.mBase = base;
        this.mPosition = SourcePositionInfo.findBeginning(sp, text);
    }

    private void parseRegex(String text) {
        Matcher m = LEADING_WHITESPACE.matcher(text);
        m.matches();
        text = m.group(1);
        m = TAG_BEGIN.matcher(text);
        int start = 0;
        int end = 0;
        while (m.find()) {
            end = m.start();
            this.tag(text, start, end);
            start = m.end() - 1;
        }
        end = text.length();
        this.tag(text, start, end);
    }

    private void tag(String text, int start, int end) {
        SourcePositionInfo pos = SourcePositionInfo.add(this.mPosition, this.mText, start);
        if (start >= 0 && end > 0 && end - start > 0) {
            Matcher m = TAG.matcher(text = text.substring(start, end));
            if (m.matches()) {
                this.tag(m.group(1), m.group(2), false, pos);
            } else {
                m = INLINE_TAG.matcher(text);
                start = 0;
                while (m.find()) {
                    String str = m.group(1);
                    String tagname = m.group(2);
                    String tagvalue = m.group(3);
                    this.tag(null, str, true, pos);
                    this.tag(tagname, tagvalue, true, pos);
                    start = m.end();
                }
                int len = text.length();
                if (start != len) {
                    this.tag(null, text.substring(start), true, pos);
                }
            }
        }
    }

    private void tag(String name, String text, boolean isInline, SourcePositionInfo pos) {
        if (name == null) {
            this.mInlineTagsList.add(new TextTagInfo("Text", "Text", text, pos));
        } else if (name.equals("@param")) {
            this.mParamTagsList.add(new ParamTagInfo("@param", "@param", text, this.mBase, pos));
        } else if (name.equals("@see")) {
            this.mSeeTagsList.add(new SeeTagInfo("@see", "@see", text, this.mBase, pos));
        } else if (name.equals("@link") || name.equals("@linkplain")) {
            this.mInlineTagsList.add(new SeeTagInfo(name, "@see", text, this.mBase, pos));
        } else if (name.equals("@throws") || name.equals("@exception")) {
            this.mThrowsTagsList.add(new ThrowsTagInfo("@throws", "@throws", text, this.mBase, pos));
        } else if (name.equals("@return")) {
            this.mReturnTagsList.add(new ParsedTagInfo("@return", "@return", text, this.mBase, pos));
        } else if (name.equals("@deprecated")) {
            if (text.length() == 0) {
                Errors.error(Errors.MISSING_COMMENT, pos, "@deprecated tag with no explanatory comment");
                text = "No replacement.";
            }
            this.mDeprecatedTagsList.add(new ParsedTagInfo("@deprecated", "@deprecated", text, this.mBase, pos));
        } else if (name.equals("@literal")) {
            this.mInlineTagsList.add(new LiteralTagInfo(text, pos));
        } else if (name.equals("@code")) {
            this.mInlineTagsList.add(new CodeTagInfo(text, pos));
        } else if (!(name.equals("@hide") || name.equals("@pending") || name.equals("@doconly"))) {
            if (name.equals("@attr")) {
                AttrTagInfo tag = new AttrTagInfo("@attr", "@attr", text, this.mBase, pos);
                this.mAttrTagsList.add(tag);
                Comment c = tag.description();
                if (c != null) {
                    for (TagInfo t : c.tags()) {
                        this.mInlineTagsList.add(t);
                    }
                }
            } else if (name.equals("@undeprecate")) {
                this.mUndeprecateTagsList.add(new TextTagInfo("@undeprecate", "@undeprecate", text, pos));
            } else if (name.equals("@sample.java")) {
                this.mInlineTagsList.add(new SampleTagInfo(name, "@include", text, SampleTagInfo.SampleLanguage.JAVA, this.mBase, pos));
            } else if (name.equals("@sample.xml")) {
                this.mInlineTagsList.add(new SampleTagInfo(name, "@include", text, SampleTagInfo.SampleLanguage.XML, this.mBase, pos));
            } else {
                boolean known = false;
                for (String s : KNOWN_TAGS) {
                    if (!s.equals(name)) continue;
                    known = true;
                    break;
                }
                if (!known) {
                    known = Doclava.knownTags.contains(name);
                }
                if (!known) {
                    Errors.error(Errors.UNKNOWN_TAG, pos == null ? null : new SourcePositionInfo(pos), "Unknown tag: " + name);
                }
                TextTagInfo t = new TextTagInfo(name, name, text, pos);
                if (isInline) {
                    this.mInlineTagsList.add(t);
                } else {
                    this.mTagsList.add(t);
                }
            }
        }
    }

    private void parseBriefTags() {
        int i;
        int N = this.mInlineTagsList.size();
        int more = -1;
        for (i = 0; i < N; ++i) {
            if (!this.mInlineTagsList.get(i).name().equals("@more")) continue;
            more = i;
        }
        if (more >= 0) {
            for (i = 0; i < more; ++i) {
                this.mBriefTagsList.add(this.mInlineTagsList.get(i));
            }
        } else {
            for (i = 0; i < N; ++i) {
                Matcher m;
                TagInfo t = this.mInlineTagsList.get(i);
                if (t.name().equals("Text") && (m = FIRST_SENTENCE.matcher(t.text())).matches()) {
                    String text = m.group(1);
                    TagInfo firstSentenceTag = new TagInfo(t.name(), t.kind(), text, t.position());
                    this.mBriefTagsList.add(firstSentenceTag);
                    break;
                }
                this.mBriefTagsList.add(t);
            }
        }
    }

    public TagInfo[] tags() {
        this.init();
        return this.mInlineTags;
    }

    public TagInfo[] tags(String name) {
        this.init();
        ArrayList<TagInfo> results = new ArrayList<TagInfo>();
        int N = this.mInlineTagsList.size();
        for (int i = 0; i < N; ++i) {
            TagInfo t = this.mInlineTagsList.get(i);
            if (!t.name().equals(name)) continue;
            results.add(t);
        }
        return results.toArray(new TagInfo[results.size()]);
    }

    public ParamTagInfo[] paramTags() {
        this.init();
        return this.mParamTags;
    }

    public SeeTagInfo[] seeTags() {
        this.init();
        return this.mSeeTags;
    }

    public ThrowsTagInfo[] throwsTags() {
        this.init();
        return this.mThrowsTags;
    }

    public TagInfo[] returnTags() {
        this.init();
        return this.mReturnTags;
    }

    public TagInfo[] deprecatedTags() {
        this.init();
        return this.mDeprecatedTags;
    }

    public TagInfo[] undeprecateTags() {
        this.init();
        return this.mUndeprecateTags;
    }

    public AttrTagInfo[] attrTags() {
        this.init();
        return this.mAttrTags;
    }

    public TagInfo[] briefTags() {
        this.init();
        return this.mBriefTags;
    }

    public boolean isHidden() {
        if (this.mHidden != -1) {
            return this.mHidden != 0;
        }
        if (Doclava.checkLevel(31)) {
            this.mHidden = 0;
            return false;
        }
        boolean b = this.mText.indexOf("@hide") >= 0 || this.mText.indexOf("@pending") >= 0;
        this.mHidden = b ? 1 : 0;
        return b;
    }

    public boolean isDocOnly() {
        if (this.mDocOnly != -1) {
            return this.mDocOnly != 0;
        }
        boolean b = this.mText != null && this.mText.indexOf("@doconly") >= 0;
        this.mDocOnly = b ? 1 : 0;
        return b;
    }

    public boolean isDeprecated() {
        if (this.mDeprecated != -1) {
            return this.mDeprecated != 0;
        }
        boolean b = this.mText != null && this.mText.indexOf("@deprecated") >= 0;
        this.mDeprecated = b ? 1 : 0;
        return b;
    }

    private void init() {
        if (!this.mInitialized) {
            this.initImpl();
        }
    }

    private void initImpl() {
        this.isHidden();
        this.isDocOnly();
        this.isDeprecated();
        if (Doclava.parseComments()) {
            this.parseRegex(this.mText);
            this.parseBriefTags();
        } else {
            this.mInlineTagsList.add(new TextTagInfo("Text", "Text", this.mText, SourcePositionInfo.add(this.mPosition, this.mText, 0)));
        }
        this.mText = null;
        this.mInitialized = true;
        this.mInlineTags = this.mInlineTagsList.toArray(new TagInfo[this.mInlineTagsList.size()]);
        this.mParamTags = this.mParamTagsList.toArray(new ParamTagInfo[this.mParamTagsList.size()]);
        this.mSeeTags = this.mSeeTagsList.toArray(new SeeTagInfo[this.mSeeTagsList.size()]);
        this.mThrowsTags = this.mThrowsTagsList.toArray(new ThrowsTagInfo[this.mThrowsTagsList.size()]);
        this.mReturnTags = ParsedTagInfo.joinTags((ParsedTagInfo[])this.mReturnTagsList.toArray(new ParsedTagInfo[this.mReturnTagsList.size()]));
        this.mDeprecatedTags = ParsedTagInfo.joinTags((ParsedTagInfo[])this.mDeprecatedTagsList.toArray(new ParsedTagInfo[this.mDeprecatedTagsList.size()]));
        this.mUndeprecateTags = this.mUndeprecateTagsList.toArray(new TagInfo[this.mUndeprecateTagsList.size()]);
        this.mAttrTags = this.mAttrTagsList.toArray(new AttrTagInfo[this.mAttrTagsList.size()]);
        this.mBriefTags = this.mBriefTagsList.toArray(new TagInfo[this.mBriefTagsList.size()]);
        this.mParamTagsList = null;
        this.mSeeTagsList = null;
        this.mThrowsTagsList = null;
        this.mReturnTagsList = null;
        this.mDeprecatedTagsList = null;
        this.mUndeprecateTagsList = null;
        this.mAttrTagsList = null;
        this.mBriefTagsList = null;
    }
}

