/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.Type;

public abstract class Op {
    private Op() {
    }

    static boolean hasTopOp(Expression e) {
        return e instanceof UnaryOp || e instanceof BinaryOp;
    }

    public static Expression minus(Expression e) {
        return new UnaryOp("-", e);
    }

    public static Expression not(Expression e) {
        if (e == ExpressionFactory.TRUE) {
            return ExpressionFactory.FALSE;
        }
        if (e == ExpressionFactory.FALSE) {
            return ExpressionFactory.TRUE;
        }
        return new UnaryOp("!", e);
    }

    public static Expression complement(Expression e) {
        return new UnaryOp("~", e);
    }

    public static Expression incr(Expression e) {
        return new TightUnaryOp(e, "++");
    }

    public static Expression decr(Expression e) {
        return new TightUnaryOp(e, "--");
    }

    public static Expression plus(Expression left, Expression right) {
        return new BinaryOp("+", left, right);
    }

    public static Expression minus(Expression left, Expression right) {
        return new BinaryOp("-", left, right);
    }

    public static Expression mul(Expression left, Expression right) {
        return new BinaryOp("*", left, right);
    }

    public static Expression div(Expression left, Expression right) {
        return new BinaryOp("/", left, right);
    }

    public static Expression mod(Expression left, Expression right) {
        return new BinaryOp("%", left, right);
    }

    public static Expression shl(Expression left, Expression right) {
        return new BinaryOp("<<", left, right);
    }

    public static Expression shr(Expression left, Expression right) {
        return new BinaryOp(">>", left, right);
    }

    public static Expression shrz(Expression left, Expression right) {
        return new BinaryOp(">>>", left, right);
    }

    public static Expression band(Expression left, Expression right) {
        return new BinaryOp("&", left, right);
    }

    public static Expression bor(Expression left, Expression right) {
        return new BinaryOp("|", left, right);
    }

    public static Expression cand(Expression left, Expression right) {
        if (left == ExpressionFactory.TRUE) {
            return right;
        }
        if (right == ExpressionFactory.TRUE) {
            return left;
        }
        if (left == ExpressionFactory.FALSE) {
            return left;
        }
        if (right == ExpressionFactory.FALSE) {
            return right;
        }
        return new BinaryOp("&&", left, right);
    }

    public static Expression cor(Expression left, Expression right) {
        if (left == ExpressionFactory.TRUE) {
            return left;
        }
        if (right == ExpressionFactory.TRUE) {
            return right;
        }
        if (left == ExpressionFactory.FALSE) {
            return right;
        }
        if (right == ExpressionFactory.FALSE) {
            return left;
        }
        return new BinaryOp("||", left, right);
    }

    public static Expression xor(Expression left, Expression right) {
        return new BinaryOp("^", left, right);
    }

    public static Expression lt(Expression left, Expression right) {
        return new BinaryOp("<", left, right);
    }

    public static Expression lte(Expression left, Expression right) {
        return new BinaryOp("<=", left, right);
    }

    public static Expression gt(Expression left, Expression right) {
        return new BinaryOp(">", left, right);
    }

    public static Expression gte(Expression left, Expression right) {
        return new BinaryOp(">=", left, right);
    }

    public static Expression eq(Expression left, Expression right) {
        return new BinaryOp("==", left, right);
    }

    public static Expression ne(Expression left, Expression right) {
        return new BinaryOp("!=", left, right);
    }

    public static Expression _instanceof(Expression left, Type right) {
        return new BinaryOp("instanceof", left, right);
    }

    public static Expression cond(Expression cond, Expression ifTrue, Expression ifFalse) {
        return new TernaryOp("?", ":", cond, ifTrue, ifFalse);
    }

    private static class TernaryOp
    extends AbstractExpression {
        String op1;
        String op2;
        Expression e1;
        Expression e2;
        Expression e3;

        TernaryOp(String op1, String op2, Expression e1, Expression e2, Expression e3) {
            this.e1 = e1;
            this.op1 = op1;
            this.e2 = e2;
            this.op2 = op2;
            this.e3 = e3;
        }

        @Override
        public void generate(Formatter f) {
            f.p('(').g(this.e1).p(this.op1).g(this.e2).p(this.op2).g(this.e3).p(')');
        }
    }

    private static class BinaryOp
    extends AbstractExpression {
        String op;
        Expression left;
        Generable right;

        BinaryOp(String op, Expression left, Generable right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public void generate(Formatter f) {
            f.p('(');
            if (this.left instanceof Assignment) {
                f.p('(').g(this.left).p(')');
            } else {
                f.g(this.left);
            }
            f.p(this.op).g(this.right).p(')');
        }
    }

    private static class TightUnaryOp
    extends UnaryOp {
        TightUnaryOp(Expression e, String op) {
            super(e, op);
        }

        @Override
        public void generate(Formatter f) {
            if (this.opFirst) {
                f.p(this.op).g(this.e);
            } else {
                f.g(this.e).p(this.op);
            }
        }
    }

    private static class UnaryOp
    extends AbstractExpression {
        protected String op;
        protected Expression e;
        protected boolean opFirst = true;

        UnaryOp(String op, Expression e) {
            this.op = op;
            this.e = e;
        }

        UnaryOp(Expression e, String op) {
            this.op = op;
            this.e = e;
            this.opFirst = false;
        }

        @Override
        public void generate(Formatter f) {
            if (this.opFirst) {
                f.p('(').p(this.op).g(this.e).p(')');
            } else {
                f.p('(').g(this.e).p(this.op).p(')');
            }
        }
    }
}

