/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.HashMap;
import java.util.Map;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CommentPart;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class DocComment
extends CommentPart
implements Generable {
    private static final long serialVersionUID = 1L;
    private final Map<String, CommentPart> atParams = new HashMap<String, CommentPart>();
    private final Map<String, Map<String, String>> atXdoclets = new HashMap<String, Map<String, String>>();
    private final Map<TypeReference, CommentPart> atThrows = new HashMap<TypeReference, CommentPart>();
    private CommentPart atReturn = null;
    private CommentPart atDeprecated = null;
    private final CodeModel owner;
    private static final String INDENT = " *     ";

    public DocComment(CodeModel owner) {
        this.owner = owner;
    }

    @Override
    public DocComment append(Object o) {
        this.add(o);
        return this;
    }

    public CommentPart addParam(String param) {
        CommentPart p = this.atParams.get(param);
        if (p == null) {
            p = new CommentPart();
            this.atParams.put(param, p);
        }
        return p;
    }

    public CommentPart addParam(Variable param) {
        return this.addParam(param.name());
    }

    public CommentPart addThrows(Class<? extends Throwable> exception) {
        return this.addThrows(this.owner.ref(exception));
    }

    public CommentPart addThrows(TypeReference exception) {
        CommentPart p = this.atThrows.get(exception);
        if (p == null) {
            p = new CommentPart();
            this.atThrows.put(exception, p);
        }
        return p;
    }

    public CommentPart addReturn(String ret) {
        if (this.atReturn == null) {
            this.atReturn = new CommentPart();
        }
        return this.atReturn;
    }

    public CommentPart addDeprecated() {
        if (this.atDeprecated == null) {
            this.atDeprecated = new CommentPart();
        }
        return this.atDeprecated;
    }

    public Map<String, String> addXdoclet(String name) {
        Map<String, String> p = this.atXdoclets.get(name);
        if (p == null) {
            p = new HashMap<String, String>();
            this.atXdoclets.put(name, p);
        }
        return p;
    }

    public Map<String, String> addXdoclet(String name, Map<String, String> attributes) {
        Map<String, String> p = this.atXdoclets.get(name);
        if (p == null) {
            p = new HashMap<String, String>();
            this.atXdoclets.put(name, p);
        }
        p.putAll(attributes);
        return p;
    }

    public Map<String, String> addXdoclet(String name, String attribute, String value) {
        Map<String, String> p = this.atXdoclets.get(name);
        if (p == null) {
            p = new HashMap<String, String>();
            this.atXdoclets.put(name, p);
        }
        p.put(attribute, value);
        return p;
    }

    @Override
    public void generate(Formatter f) {
        f.p("/**").nl();
        this.format(f, " * ");
        f.p(" * ").nl();
        for (Map.Entry<String, CommentPart> entry : this.atParams.entrySet()) {
            f.p(" * @param ").p(entry.getKey()).nl();
            entry.getValue().format(f, INDENT);
        }
        if (this.atReturn != null) {
            f.p(" * @return").nl();
            this.atReturn.format(f, INDENT);
        }
        for (Map.Entry<Object, CommentPart> entry : this.atThrows.entrySet()) {
            f.p(" * @throws ").t((TypeReference)entry.getKey()).nl();
            entry.getValue().format(f, INDENT);
        }
        if (this.atDeprecated != null) {
            f.p(" * @deprecated").nl();
            this.atDeprecated.format(f, INDENT);
        }
        for (Map.Entry<Object, Object> entry : this.atXdoclets.entrySet()) {
            f.p(" * @").p((String)entry.getKey());
            if (entry.getValue() != null) {
                for (Map.Entry a : ((Map)entry.getValue()).entrySet()) {
                    f.p(" ").p((String)a.getKey()).p("= \"").p((String)a.getValue()).p("\"");
                }
            }
            f.nl();
        }
        f.p(" */").nl();
    }
}

