/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public final class ForEach
implements Statement {
    private final Type type;
    private final String var;
    private Block body = null;
    private final Expression collection;
    private final Variable loopVar;

    public ForEach(Type vartype, String variable, Expression collection) {
        this.type = vartype;
        this.var = variable;
        this.collection = collection;
        this.loopVar = new Variable(Modifiers.forVar(0), this.type, this.var, collection);
    }

    public Variable var() {
        return this.loopVar;
    }

    public Block body() {
        if (this.body == null) {
            this.body = new Block();
        }
        return this.body;
    }

    @Override
    public void state(Formatter f) {
        f.p("for (");
        f.g(this.type).id(this.var).p(": ").g(this.collection);
        f.p(')');
        if (this.body != null) {
            f.g(this.body).nl();
        } else {
            f.p(';').nl();
        }
    }
}

